/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.constraint;

import me.zeroeightsix.fiber.Identifier;

public enum ConstraintType {
    FINAL(false, ConstraintType.identifier("final")),
    NUMERICAL_LOWER_BOUND(true, ConstraintType.identifier("min")),
    NUMERICAL_UPPER_BOUND(true, ConstraintType.identifier("max")),
    MINIMUM_LENGTH(true, ConstraintType.identifier("min_length")),
    MAXIMUM_LENGTH(true, ConstraintType.identifier("max_length")),
    STRING_MATCHING(false, ConstraintType.identifier("regex")),
    COMPONENTS_MATCH(false, ConstraintType.identifier("component")),
    COMPOSITE(false, ConstraintType.identifier("composite"));

    private final boolean numerical;
    private final Identifier identifier;

    private ConstraintType(boolean numerical, Identifier identifier) {
        this.numerical = numerical;
        this.identifier = identifier;
    }

    private static Identifier identifier(String name) {
        return new Identifier("fiber", name);
    }

    public boolean isNumerical() {
        return this.numerical;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }
}

