/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.annotation.AnnotatedSettings;
import me.zeroeightsix.fiber.builder.ConfigAggregateBuilder;
import me.zeroeightsix.fiber.builder.ConfigValueBuilder;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.tree.ConfigNode;
import me.zeroeightsix.fiber.tree.NodeLike;
import me.zeroeightsix.fiber.tree.TreeItem;

public class ConfigNodeBuilder
implements NodeLike {
    private final Map<String, TreeItem> items = new HashMap<String, TreeItem>();
    @Nullable
    protected ConfigNodeBuilder parent = null;
    @Nullable
    protected String name = null;
    @Nullable
    private String comment;
    private boolean serializeSeparately;
    private ConfigNode built;

    @Override
    @Nonnull
    public Collection<TreeItem> getItems() {
        return this.items.values();
    }

    @Override
    @Nullable
    public TreeItem lookup(String name) {
        return this.items.get(name);
    }

    public ConfigNodeBuilder withParent(ConfigNodeBuilder parent) {
        if (this.name == null && parent != null) {
            throw new IllegalStateException("A child node needs a name");
        }
        this.parent = parent;
        return this;
    }

    public ConfigNodeBuilder withName(String name) {
        if (name == null && this.parent != null) {
            throw new IllegalStateException("Cannot remove the name from a child node");
        }
        this.name = name;
        return this;
    }

    public ConfigNodeBuilder withComment(@Nullable String comment) {
        this.comment = comment;
        return this;
    }

    public ConfigNodeBuilder withSeparateSerialization() {
        this.withSeparateSerialization(true);
        return this;
    }

    public ConfigNodeBuilder withSeparateSerialization(boolean serializeSeparately) {
        this.serializeSeparately = serializeSeparately;
        return this;
    }

    public ConfigNodeBuilder applyFromPojo(Object pojo) throws FiberException {
        AnnotatedSettings.applyToNode(this, pojo);
        return this;
    }

    public <T> ConfigValueBuilder<T> beginValue(@Nonnull String name, @Nonnull Class<T> type) {
        return new ConfigValueBuilder<T>(this, name, type);
    }

    public <T> ConfigValueBuilder<T> beginValue(@Nonnull String name, @Nonnull T defaultValue) {
        Class<E[]> type = defaultValue.getClass();
        if (ConfigAggregateBuilder.isAggregate(type)) {
            if (type.isArray()) {
                return ConfigAggregateBuilder.create(this, name, type);
            }
            return ConfigAggregateBuilder.create(this, name, type, null);
        }
        return new ConfigValueBuilder(this, name, type).withDefaultValue(defaultValue);
    }

    public <E> ConfigAggregateBuilder<E[], E> beginAggregateValue(@Nonnull String name, @Nonnull E[] defaultValue) {
        Class<E[]> type = defaultValue.getClass();
        return ConfigAggregateBuilder.create(this, name, type).withDefaultValue(defaultValue);
    }

    public <C extends Collection<E>, E> ConfigAggregateBuilder<C, E> beginAggregateValue(@Nonnull String name, @Nonnull C defaultValue, @Nullable Class<E> elementType) {
        Class<?> type = defaultValue.getClass();
        return ConfigAggregateBuilder.create(this, name, type, elementType).withDefaultValue(defaultValue);
    }

    public ConfigNodeBuilder add(@Nonnull TreeItem item) throws FiberException {
        this.add(item, false);
        return this;
    }

    public ConfigNodeBuilder add(@Nonnull TreeItem item, boolean overwrite) throws FiberException {
        if (!overwrite && this.items.containsKey(item.getName())) {
            throw new FiberException("Attempt to replace node " + item.getName());
        }
        this.items.put(item.getName(), item);
        return this;
    }

    public TreeItem remove(String name) {
        return this.items.remove(name);
    }

    public ConfigNodeBuilder fork(String name) {
        return new ConfigNodeBuilder().withName(name).withParent(this);
    }

    public ConfigNode build() {
        if (this.built != null) {
            throw new IllegalStateException("Cannot build a node more than once");
        }
        this.built = new ConfigNode(this.name, this.comment, this.items, this.serializeSeparately);
        if (this.parent != null) {
            assert (this.name != null);
            try {
                this.parent.add(this.built);
            }
            catch (FiberException e) {
                throw new RuntimeFiberException("Failed to attach built node to parent", e);
            }
        }
        return this.built;
    }

    public ConfigNodeBuilder finishNode() {
        return this.finishNode(n -> {});
    }

    public ConfigNodeBuilder finishNode(Consumer<ConfigNode> action) {
        if (this.parent == null) {
            throw new IllegalStateException("finishNode should not be called for a root node. Use build instead.");
        }
        action.accept(this.build());
        return this.parent;
    }
}

