/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.tree;

import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.tree.ConfigLeaf;
import me.zeroeightsix.fiber.tree.Property;

public class ConfigValue<T>
extends ConfigLeaf
implements Property<T> {
    @Nullable
    private T value;
    @Nullable
    private final T defaultValue;
    @Nonnull
    private final BiConsumer<T, T> listener;
    @Nonnull
    private final List<Constraint<? super T>> constraints;
    @Nonnull
    private final Class<T> type;

    public ConfigValue(@Nonnull String name, @Nullable String comment, @Nullable T defaultValue, @Nonnull BiConsumer<T, T> listener, @Nonnull List<Constraint<? super T>> constraints, @Nonnull Class<T> type) {
        super(name, comment);
        this.value = defaultValue;
        this.defaultValue = defaultValue;
        this.listener = listener;
        this.constraints = constraints;
        this.type = type;
    }

    @Override
    @Nullable
    public T getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean setValue(@Nullable T value) {
        if (!this.accepts(value)) {
            return false;
        }
        T oldValue = this.value;
        this.value = value;
        this.listener.accept(oldValue, value);
        return true;
    }

    @Override
    public boolean accepts(@Nullable T value) {
        for (Constraint<T> constraint : this.constraints) {
            if (constraint.test(value)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public BiConsumer<T, T> getListener() {
        return this.listener;
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Nonnull
    public List<Constraint<? super T>> getConstraints() {
        return this.constraints;
    }
}

