/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.builder.ConfigNodeBuilder;
import me.zeroeightsix.fiber.builder.constraint.ConstraintsBuilder;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.constraint.FinalConstraint;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.tree.ConfigValue;

public class ConfigValueBuilder<T> {
    private final ConfigNodeBuilder parentNode;
    @Nonnull
    protected final Class<T> type;
    @Nonnull
    private String name;
    @Nullable
    private String comment = null;
    @Nullable
    private T defaultValue = null;
    private boolean isFinal = false;
    private BiConsumer<T, T> consumer = (t, t2) -> {};
    protected List<Constraint<? super T>> constraintList = new ArrayList<Constraint<? super T>>();

    public ConfigValueBuilder(ConfigNodeBuilder parentNode, @Nonnull String name, @Nonnull Class<T> type) {
        this.parentNode = parentNode;
        this.name = name;
        this.type = type;
    }

    public ConfigValueBuilder<T> withName(String name) {
        this.name = name;
        return this;
    }

    public ConfigValueBuilder<T> withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public ConfigValueBuilder<T> withListener(BiConsumer<T, T> consumer) {
        BiConsumer prevConsumer = this.consumer;
        this.consumer = (t, t2) -> {
            prevConsumer.accept(t, t2);
            consumer.accept(t, t2);
        };
        return this;
    }

    public ConfigValueBuilder<T> withDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ConfigValueBuilder<T> withFinality() {
        this.isFinal = true;
        return this;
    }

    public ConfigValueBuilder<T> withFinality(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    public ConstraintsBuilder<T> beginConstraints() {
        return new ConstraintsBuilder<T>(this, this.constraintList, this.type);
    }

    public ConfigValue<T> build() {
        if (this.defaultValue != null) {
            for (Constraint<T> constraint : this.constraintList) {
                if (constraint.test(this.defaultValue)) continue;
                throw new RuntimeFiberException("Default value '" + this.defaultValue + "' does not satisfy constraints");
            }
        }
        ArrayList<Constraint<T>> constraints = new ArrayList<Constraint<T>>(this.constraintList);
        if (this.isFinal) {
            constraints.add(0, FinalConstraint.instance());
        }
        ConfigValue<? super T> built = new ConfigValue<T>(this.name, this.comment, this.defaultValue, this.consumer, constraints, this.type);
        if (this.parentNode != null) {
            try {
                this.parentNode.add(built);
            }
            catch (FiberException e) {
                throw new RuntimeFiberException("Failed to register leaf to node", e);
            }
        }
        return built;
    }

    public ConfigNodeBuilder finishValue() {
        return this.finishValue(n -> {});
    }

    public ConfigNodeBuilder finishValue(Consumer<ConfigValue<T>> action) {
        action.accept(this.build());
        return this.parentNode;
    }
}

