/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.builder.ConfigNodeBuilder;
import me.zeroeightsix.fiber.tree.ConfigLeaf;
import me.zeroeightsix.fiber.tree.Node;
import me.zeroeightsix.fiber.tree.TreeItem;

public class ConfigNode
extends ConfigLeaf
implements Node {
    private final Map<String, TreeItem> items;
    private final boolean serializeSeparately;

    public static ConfigNodeBuilder builder() {
        return new ConfigNodeBuilder();
    }

    public ConfigNode(String name, @Nullable String comment, @Nonnull Map<String, TreeItem> items, boolean serializeSeparately) {
        super(name, comment);
        this.items = Collections.unmodifiableMap(new TreeMap<String, TreeItem>(items));
        this.serializeSeparately = serializeSeparately;
    }

    public ConfigNode(@Nonnull String name, @Nullable String comment) {
        this(name, comment, Collections.emptyMap(), false);
    }

    public ConfigNode() {
        this(null, null, Collections.emptyMap(), false);
    }

    @Override
    @Nonnull
    public Collection<TreeItem> getItems() {
        return this.items.values();
    }

    @Override
    @Nullable
    public TreeItem lookup(String name) {
        return this.items.get(name);
    }

    @Override
    public boolean isSerializedSeparately() {
        return this.serializeSeparately;
    }
}

