/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder.constraint;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.builder.ConfigAggregateBuilder;
import me.zeroeightsix.fiber.builder.constraint.AbstractConstraintsBuilder;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.constraint.ConstraintType;
import me.zeroeightsix.fiber.constraint.ValuedConstraint;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;

public final class ComponentConstraintsBuilder<S, A, T>
extends AbstractConstraintsBuilder<S, A, T> {
    @Nullable
    private final Class<A> aggregateType;

    public ComponentConstraintsBuilder(S source, List<Constraint<? super A>> sourceConstraints, @Nullable Class<A> aggregateType, @Nullable Class<T> componentType) {
        super(source, sourceConstraints, componentType);
        this.aggregateType = aggregateType;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> atLeast(T min) throws RuntimeFiberException {
        super.atLeast(min);
        return this;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> atMost(T max) {
        super.atMost(max);
        return this;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> range(T min, T max) {
        super.range(min, max);
        return this;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> minLength(int min) {
        super.minLength(min);
        return this;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> maxLength(int max) {
        super.maxLength(max);
        return this;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> regex(String regexPattern) {
        super.regex(regexPattern);
        return this;
    }

    public S finishComponent() {
        this.sourceConstraints.add(new ComponentConstraint(this.newConstraints, this.aggregateType));
        return (S)this.source;
    }

    public static class ComponentConstraint<A, T>
    extends ValuedConstraint<List<Constraint<? super T>>, A> {
        private final BiPredicate<Constraint<? super T>, A> allMatch;

        public ComponentConstraint(List<Constraint<? super T>> constraints, Class<A> type) {
            super(ConstraintType.COMPONENTS_MATCH, constraints);
            this.allMatch = this.getAggregateMatcher(type);
        }

        @Nonnull
        private BiPredicate<Constraint<? super T>, A> getAggregateMatcher(@Nullable Class<A> type) {
            BiPredicate<Constraint, Object> allMatch;
            if (type == null) {
                allMatch = (constraint, value) -> this.getAggregateMatcher(value.getClass()).test((Constraint<Constraint>)constraint, value);
            } else if (type.isArray()) {
                allMatch = (constraint, value) -> {
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Object t = Array.get(value, i);
                        if (constraint.test(t)) continue;
                        return false;
                    }
                    return true;
                };
            } else if (Collection.class.isAssignableFrom(type)) {
                allMatch = (constraint, value) -> {
                    for (Object t : (Collection)value) {
                        if (constraint.test(t)) continue;
                        return false;
                    }
                    return true;
                };
            } else {
                assert (!ConfigAggregateBuilder.isAggregate(type));
                throw new RuntimeFiberException(type + " is not an aggregate type not have a known length or size");
            }
            return allMatch;
        }

        @Override
        public boolean test(A value) {
            for (Constraint constraint : (List)this.getValue()) {
                if (this.allMatch.test(constraint, value)) continue;
                return false;
            }
            return true;
        }
    }
}

