/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.tree.ConfigGroup;
import me.zeroeightsix.fiber.tree.ConfigNode;
import me.zeroeightsix.fiber.tree.ConfigNodeImpl;

public class ConfigGroupImpl
extends ConfigNodeImpl
implements ConfigGroup {
    private final Map<String, ConfigNode> items;
    private final boolean serializeSeparately;

    public ConfigGroupImpl(String name, @Nullable String comment, @Nonnull Map<String, ConfigNode> items, boolean serializeSeparately) {
        super(name, comment);
        this.items = Collections.unmodifiableMap(new TreeMap<String, ConfigNode>(items));
        this.serializeSeparately = serializeSeparately;
    }

    public ConfigGroupImpl(@Nonnull String name, @Nullable String comment) {
        this(name, comment, Collections.emptyMap(), false);
    }

    public ConfigGroupImpl() {
        this(null, null, Collections.emptyMap(), false);
    }

    @Override
    @Nonnull
    public Collection<ConfigNode> getItems() {
        return this.items.values();
    }

    @Override
    @Nullable
    public ConfigNode lookup(String name) {
        return this.items.get(name);
    }

    @Override
    public boolean isSerializedSeparately() {
        return this.serializeSeparately;
    }
}

