/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.exception.FiberQueryException;
import me.zeroeightsix.fiber.tree.ConfigGroup;
import me.zeroeightsix.fiber.tree.ConfigLeaf;
import me.zeroeightsix.fiber.tree.ConfigNode;
import me.zeroeightsix.fiber.tree.ConfigTree;

public final class ConfigQuery<T extends ConfigNode> {
    private final List<String> path;
    private final Class<? super T> nodeType;
    @Nullable
    private final Class<?> valueType;

    public static ConfigQuery<ConfigGroup> subtree(String first, String ... more) {
        return new ConfigQuery<ConfigGroup>(ConfigGroup.class, null, first, more);
    }

    public static <V> ConfigQuery<ConfigLeaf<V>> property(Class<? super V> propertyType, String first, String ... more) {
        return new ConfigQuery<ConfigLeaf<V>>(ConfigLeaf.class, propertyType, first, more);
    }

    private ConfigQuery(Class<? super T> nodeType, @Nullable Class<?> valueType, String first, String[] path) {
        this.nodeType = nodeType;
        this.valueType = valueType;
        this.path = new ArrayList<String>();
        this.path.add(first);
        this.path.addAll(Arrays.asList(path));
    }

    public Optional<T> search(ConfigTree cfg) {
        try {
            return Optional.of(this.run(cfg));
        }
        catch (FiberQueryException e) {
            return Optional.empty();
        }
    }

    @Nonnull
    public T run(ConfigTree cfg) throws FiberQueryException {
        List<String> path = this.path;
        ConfigTree subtree = cfg;
        int lastIndex = path.size() - 1;
        for (int i = 0; i < lastIndex; ++i) {
            subtree = this.lookupChild(subtree, path.get(i), ConfigGroup.class, null);
        }
        ConfigNode result = (ConfigNode)this.lookupChild(subtree, path.get(lastIndex), this.nodeType, this.valueType);
        return (T)result;
    }

    private <N> N lookupChild(ConfigTree tree, String name, Class<N> nodeType, @Nullable Class<?> valueType) throws FiberQueryException {
        ConfigNode node = tree.lookup(name);
        if (nodeType.isInstance(node) && (valueType == null || valueType == ((ConfigLeaf)node).getType())) {
            return nodeType.cast(node);
        }
        if (node != null) {
            throw new FiberQueryException.WrongType(tree, node, nodeType, valueType);
        }
        throw new FiberQueryException.MissingChild(name, tree);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.nodeType.getSimpleName());
        if (this.valueType != null) {
            sb.append('<').append(this.valueType.getSimpleName()).append('>');
        }
        return sb.append("@'").append(String.join((CharSequence)".", this.path)).append('\'').toString();
    }
}

