/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.annotation.AnnotatedSettings;
import me.zeroeightsix.fiber.builder.ConfigAggregateBuilder;
import me.zeroeightsix.fiber.builder.ConfigLeafBuilder;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.tree.ConfigBranch;
import me.zeroeightsix.fiber.tree.ConfigBranchImpl;
import me.zeroeightsix.fiber.tree.ConfigNode;
import me.zeroeightsix.fiber.tree.ConfigTree;

public class ConfigTreeBuilder
implements ConfigTree {
    private final Map<String, ConfigNode> items = new HashMap<String, ConfigNode>();
    @Nullable
    protected ConfigTreeBuilder parent = null;
    @Nullable
    protected String name = null;
    @Nullable
    private String comment;
    private boolean serializeSeparately;
    private ConfigBranch built;

    @Override
    @Nonnull
    public Collection<ConfigNode> getItems() {
        return this.items.values();
    }

    @Override
    @Nullable
    public ConfigNode lookup(String name) {
        return this.items.get(name);
    }

    public ConfigTreeBuilder withParent(ConfigTreeBuilder parent) {
        if (this.name == null && parent != null) {
            throw new IllegalStateException("A child node needs a name");
        }
        this.parent = parent;
        return this;
    }

    public ConfigTreeBuilder withName(String name) {
        if (name == null && this.parent != null) {
            throw new IllegalStateException("Cannot remove the name from a child node");
        }
        this.name = name;
        return this;
    }

    public ConfigTreeBuilder withComment(@Nullable String comment) {
        this.comment = comment;
        return this;
    }

    public ConfigTreeBuilder withSeparateSerialization() {
        this.withSeparateSerialization(true);
        return this;
    }

    public ConfigTreeBuilder withSeparateSerialization(boolean serializeSeparately) {
        this.serializeSeparately = serializeSeparately;
        return this;
    }

    public ConfigTreeBuilder applyFromPojo(Object pojo) throws FiberException {
        AnnotatedSettings.applyToNode(this, pojo);
        return this;
    }

    public <T> ConfigLeafBuilder<T> beginValue(@Nonnull String name, @Nonnull Class<T> type) {
        return new ConfigLeafBuilder<T>(this, name, type);
    }

    public <T> ConfigLeafBuilder<T> beginValue(@Nonnull String name, @Nonnull T defaultValue) {
        Class<E[]> type = defaultValue.getClass();
        if (ConfigAggregateBuilder.isAggregate(type)) {
            if (type.isArray()) {
                return ConfigAggregateBuilder.create(this, name, type);
            }
            return ConfigAggregateBuilder.create(this, name, type, null);
        }
        return new ConfigLeafBuilder(this, name, type).withDefaultValue(defaultValue);
    }

    public <E> ConfigAggregateBuilder<E[], E> beginAggregateValue(@Nonnull String name, @Nonnull E[] defaultValue) {
        Class<E[]> type = defaultValue.getClass();
        return ConfigAggregateBuilder.create(this, name, type).withDefaultValue(defaultValue);
    }

    public <C extends Collection<E>, E> ConfigAggregateBuilder<C, E> beginAggregateValue(@Nonnull String name, @Nonnull C defaultValue, @Nullable Class<E> elementType) {
        Class<?> type = defaultValue.getClass();
        return ConfigAggregateBuilder.create(this, name, type, elementType).withDefaultValue(defaultValue);
    }

    public ConfigTreeBuilder add(@Nonnull ConfigNode item) throws FiberException {
        this.add(item, false);
        return this;
    }

    public ConfigTreeBuilder add(@Nonnull ConfigNode item, boolean overwrite) throws FiberException {
        if (!overwrite && this.items.containsKey(item.getName())) {
            throw new FiberException("Attempt to replace node " + item.getName());
        }
        this.items.put(item.getName(), item);
        return this;
    }

    public ConfigNode remove(String name) {
        return this.items.remove(name);
    }

    public ConfigTreeBuilder fork(String name) {
        return new ConfigTreeBuilder().withName(name).withParent(this);
    }

    public ConfigBranch build() {
        if (this.built != null) {
            throw new IllegalStateException("Cannot build a node more than once");
        }
        this.built = new ConfigBranchImpl(this.name, this.comment, this.items, this.serializeSeparately);
        if (this.parent != null) {
            assert (this.name != null);
            try {
                this.parent.add(this.built);
            }
            catch (FiberException e) {
                throw new RuntimeFiberException("Failed to attach built node to parent", e);
            }
        }
        return this.built;
    }

    public ConfigTreeBuilder finishNode() {
        return this.finishNode(n -> {});
    }

    public ConfigTreeBuilder finishNode(Consumer<ConfigBranch> action) {
        if (this.parent == null) {
            throw new IllegalStateException("finishNode should not be called for a root node. Use build instead.");
        }
        action.accept(this.build());
        return this.parent;
    }
}

