/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder.constraint;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.constraint.ConstraintType;
import me.zeroeightsix.fiber.constraint.LengthConstraint;
import me.zeroeightsix.fiber.constraint.NumberConstraint;
import me.zeroeightsix.fiber.constraint.RegexConstraint;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;

public abstract class AbstractConstraintsBuilder<S, A, T> {
    protected final S source;
    protected final List<Constraint<? super A>> sourceConstraints;
    @Nullable
    protected final Class<T> type;
    final List<Constraint<? super T>> newConstraints = new ArrayList<Constraint<? super T>>();

    AbstractConstraintsBuilder(S source, List<Constraint<? super A>> sourceConstraints, @Nullable Class<T> type) {
        this.source = source;
        this.sourceConstraints = sourceConstraints;
        this.type = type;
    }

    public AbstractConstraintsBuilder<S, A, T> atLeast(T min) throws RuntimeFiberException {
        this.checkNumerical();
        this.checkNumerical(min);
        this.newConstraints.add(new NumberConstraint<Number>(ConstraintType.NUMERICAL_LOWER_BOUND, (Number)min));
        return this;
    }

    public AbstractConstraintsBuilder<S, A, T> atMost(T max) {
        this.checkNumerical();
        this.checkNumerical(max);
        this.newConstraints.add(new NumberConstraint<Number>(ConstraintType.NUMERICAL_UPPER_BOUND, (Number)max));
        return this;
    }

    public AbstractConstraintsBuilder<S, A, T> range(T min, T max) {
        this.atLeast(min);
        this.atMost(max);
        return this;
    }

    public AbstractConstraintsBuilder<S, A, T> minLength(int min) {
        if (min < 0) {
            throw new RuntimeFiberException(min + " is not a valid length");
        }
        this.newConstraints.add(LengthConstraint.min(this.type, min));
        return this;
    }

    public AbstractConstraintsBuilder<S, A, T> maxLength(int max) {
        if (max < 0) {
            throw new RuntimeFiberException(max + " is not a valid length");
        }
        this.newConstraints.add(LengthConstraint.max(this.type, max));
        return this;
    }

    public AbstractConstraintsBuilder<S, A, T> regex(@RegEx String regexPattern) {
        this.checkCharSequence();
        this.newConstraints.add(new RegexConstraint(Pattern.compile(regexPattern)));
        return this;
    }

    private void checkNumerical() {
        if (this.type != null && !Number.class.isAssignableFrom(this.type)) {
            throw new RuntimeFiberException("Can't apply numerical constraint to non-numerical setting");
        }
    }

    private void checkNumerical(T value) {
        if (this.type != null && !Number.class.isAssignableFrom(value.getClass())) {
            throw new RuntimeFiberException("'" + value + "' is not a number");
        }
    }

    private void checkCharSequence() {
        if (this.type != null && !CharSequence.class.isAssignableFrom(this.type)) {
            throw new RuntimeFiberException("Can only apply regex pattern constraint to character sequences");
        }
    }
}

