/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.builder.ConfigTreeBuilder;
import me.zeroeightsix.fiber.builder.constraint.ConstraintsBuilder;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.constraint.FinalConstraint;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.tree.ConfigLeaf;
import me.zeroeightsix.fiber.tree.ConfigLeafImpl;

public class ConfigLeafBuilder<T> {
    private final ConfigTreeBuilder parentNode;
    @Nonnull
    protected final Class<T> type;
    @Nonnull
    private String name;
    @Nullable
    private String comment = null;
    @Nullable
    private T defaultValue = null;
    private boolean isFinal = false;
    private BiConsumer<T, T> consumer = (t, t2) -> {};
    protected List<Constraint<? super T>> constraintList = new ArrayList<Constraint<? super T>>();

    public ConfigLeafBuilder(ConfigTreeBuilder parentNode, @Nonnull String name, @Nonnull Class<T> type) {
        this.parentNode = parentNode;
        this.name = name;
        this.type = type;
    }

    @Nonnull
    public Class<T> getType() {
        return this.type;
    }

    public ConfigLeafBuilder<T> withName(String name) {
        this.name = name;
        return this;
    }

    public ConfigLeafBuilder<T> withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public ConfigLeafBuilder<T> withListener(BiConsumer<T, T> consumer) {
        BiConsumer prevConsumer = this.consumer;
        this.consumer = (t, t2) -> {
            prevConsumer.accept(t, t2);
            consumer.accept(t, t2);
        };
        return this;
    }

    public ConfigLeafBuilder<T> withDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ConfigLeafBuilder<T> withFinality() {
        this.isFinal = true;
        return this;
    }

    public ConfigLeafBuilder<T> withFinality(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    public ConstraintsBuilder<T> beginConstraints() {
        return new ConstraintsBuilder<T>(this, this.constraintList, this.type);
    }

    public ConfigLeaf<T> build() {
        if (this.defaultValue != null) {
            for (Constraint<T> constraint : this.constraintList) {
                if (constraint.test(this.defaultValue)) continue;
                throw new RuntimeFiberException("Default value '" + this.defaultValue + "' does not satisfy constraints");
            }
        }
        ArrayList<Constraint<T>> constraints = new ArrayList<Constraint<T>>(this.constraintList);
        if (this.isFinal) {
            constraints.add(0, FinalConstraint.instance());
        }
        ConfigLeafImpl<? super T> built = new ConfigLeafImpl<T>(this.name, this.comment, this.defaultValue, this.consumer, constraints, this.type);
        if (this.parentNode != null) {
            try {
                this.parentNode.add(built);
            }
            catch (FiberException e) {
                throw new RuntimeFiberException("Failed to register leaf to node", e);
            }
        }
        return built;
    }

    public ConfigTreeBuilder finishValue() {
        return this.finishValue(n -> {});
    }

    public ConfigTreeBuilder finishValue(Consumer<ConfigLeaf<T>> action) {
        action.accept(this.build());
        return this.parentNode;
    }
}

