/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.zeroeightsix.fiber.NodeOperations;
import me.zeroeightsix.fiber.annotation.ConstraintAnnotationProcessor;
import me.zeroeightsix.fiber.annotation.Listener;
import me.zeroeightsix.fiber.annotation.Setting;
import me.zeroeightsix.fiber.annotation.SettingAnnotationProcessor;
import me.zeroeightsix.fiber.annotation.Settings;
import me.zeroeightsix.fiber.annotation.convention.NoNamingConvention;
import me.zeroeightsix.fiber.annotation.convention.SettingNamingConvention;
import me.zeroeightsix.fiber.annotation.exception.MalformedFieldException;
import me.zeroeightsix.fiber.annotation.magic.TypeMagic;
import me.zeroeightsix.fiber.builder.ConfigAggregateBuilder;
import me.zeroeightsix.fiber.builder.ConfigLeafBuilder;
import me.zeroeightsix.fiber.builder.ConfigTreeBuilder;
import me.zeroeightsix.fiber.builder.constraint.AbstractConstraintsBuilder;
import me.zeroeightsix.fiber.builder.constraint.AggregateConstraintsBuilder;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.tree.ConfigNode;
import me.zeroeightsix.fiber.tree.ConfigTree;

public class AnnotatedSettings {
    public static final AnnotatedSettings DEFAULT_SETTINGS = new AnnotatedSettings();
    private final Map<Class<? extends Annotation>, SettingAnnotationProcessor.Value<?>> valueSettingProcessors = new HashMap();
    private final Map<Class<? extends Annotation>, SettingAnnotationProcessor.Group<?>> groupSettingProcessors = new HashMap();
    private final Map<Class<? extends Annotation>, ConstraintProcessorEntry> constraintProcessors = new HashMap<Class<? extends Annotation>, ConstraintProcessorEntry>();

    public AnnotatedSettings() {
        this.registerGroupProcessor(Setting.Group.class, (annotation, field, pojo, node) -> {});
        this.registerConstraintProcessor(Setting.Constrain.Range.class, Number.class, (annotation, annotated, pojo, constraints) -> {
            if (annotation.min() > Double.NEGATIVE_INFINITY) {
                constraints.atLeast(annotation.min());
            }
            if (annotation.max() < Double.POSITIVE_INFINITY) {
                constraints.atMost(annotation.max());
            }
        });
        this.registerConstraintProcessor(Setting.Constrain.BigRange.class, Number.class, (annotation, annotated, pojo, constraints) -> {
            if (!annotation.min().isEmpty()) {
                constraints.atLeast(new BigDecimal(annotation.min()));
            }
            if (!annotation.max().isEmpty()) {
                constraints.atMost(new BigDecimal(annotation.max()));
            }
        });
        this.registerConstraintProcessor(Setting.Constrain.MinLength.class, Object.class, (annotation, annotated, pojo, constraints) -> constraints.minLength(annotation.value()));
        this.registerConstraintProcessor(Setting.Constrain.MaxLength.class, Object.class, (annotation, annotated, pojo, constraints) -> constraints.maxLength(annotation.value()));
        this.registerConstraintProcessor(Setting.Constrain.Regex.class, CharSequence.class, (annotation, annotated, pojo, constraints) -> constraints.regex(annotation.value()));
    }

    public <A extends Annotation> AnnotatedSettings registerSettingProcessor(Class<A> annotationType, SettingAnnotationProcessor.Value<A> processor) {
        if (this.valueSettingProcessors.containsKey(annotationType)) {
            throw new IllegalStateException("Cannot register multiple setting processors for the same annotation (" + annotationType + ")");
        }
        this.valueSettingProcessors.put(annotationType, processor);
        return this;
    }

    public <A extends Annotation> AnnotatedSettings registerGroupProcessor(Class<A> annotationType, SettingAnnotationProcessor.Group<A> processor) {
        if (this.groupSettingProcessors.containsKey(annotationType)) {
            throw new IllegalStateException("Cannot register multiple node processors for the same annotation (" + annotationType + ")");
        }
        this.groupSettingProcessors.put(annotationType, processor);
        return this;
    }

    public <A extends Annotation, T> AnnotatedSettings registerConstraintProcessor(Class<A> annotationType, Class<T> valueType, ConstraintAnnotationProcessor<A, ? super T> processor) {
        if (this.constraintProcessors.containsKey(annotationType)) {
            throw new IllegalStateException("Cannot register multiple processors for the same annotation (" + annotationType + ")");
        }
        this.constraintProcessors.put(annotationType, new ConstraintProcessorEntry(processor, valueType));
        return this;
    }

    public ConfigNode asNode(Object pojo) throws FiberException {
        ConfigTreeBuilder builder = ConfigTree.builder();
        this.applyToNode(builder, pojo);
        return builder.build();
    }

    public <P> void applyToNode(ConfigTreeBuilder mergeTo, P pojo) throws FiberException {
        SettingNamingConvention convention;
        boolean onlyAnnotated;
        Class<?> pojoClass = pojo.getClass();
        if (pojoClass.isAnnotationPresent(Settings.class)) {
            Settings settingsAnnotation = pojoClass.getAnnotation(Settings.class);
            onlyAnnotated = settingsAnnotation.onlyAnnotated();
            convention = this.createConvention(settingsAnnotation.namingConvention());
        } else {
            onlyAnnotated = false;
            convention = new NoNamingConvention();
        }
        NodeOperations.mergeTo(this.constructNode(pojoClass, pojo, onlyAnnotated, convention), mergeTo);
    }

    private <P> ConfigTreeBuilder constructNode(Class<P> pojoClass, P pojo, boolean onlyAnnotated, SettingNamingConvention convention) throws FiberException {
        ConfigTreeBuilder node = ConfigTree.builder();
        ArrayList defaultEmpty = new ArrayList();
        Map<String, List<Member>> listenerMap = this.findListeners(pojoClass);
        for (Field field : pojoClass.getDeclaredFields()) {
            if (field.isSynthetic() || !this.isIncluded(field, onlyAnnotated)) continue;
            this.checkViolation(field);
            String name = this.findName(field, convention);
            if (field.isAnnotationPresent(Setting.Group.class)) {
                this.fieldToNode(pojo, node, field, name);
                continue;
            }
            this.fieldToItem(node, field, pojo, name, listenerMap.getOrDefault(name, defaultEmpty));
        }
        return node;
    }

    private Map<String, List<Member>> findListeners(Class<?> pojoClass) {
        return Stream.concat(Arrays.stream(pojoClass.getDeclaredFields()), Arrays.stream(pojoClass.getDeclaredMethods())).filter(accessibleObject -> accessibleObject.isAnnotationPresent(Listener.class)).collect(Collectors.groupingBy(accessibleObject -> ((AccessibleObject)((Object)accessibleObject)).getAnnotation(Listener.class).value()));
    }

    private boolean isIncluded(Field field, boolean onlyAnnotated) {
        if (this.isIgnored(field)) {
            return false;
        }
        return !onlyAnnotated || field.isAnnotationPresent(Setting.class);
    }

    private boolean isIgnored(Field field) {
        return this.getSettingAnnotation(field).map(Setting::ignore).orElse(false) != false || Modifier.isTransient(field.getModifiers());
    }

    private void checkViolation(Field field) throws FiberException {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new FiberException("Field '" + field.getName() + "' can not be final");
        }
    }

    private Optional<Setting> getSettingAnnotation(Field field) {
        return field.isAnnotationPresent(Setting.class) ? Optional.of(field.getAnnotation(Setting.class)) : Optional.empty();
    }

    private <P> void fieldToNode(P pojo, ConfigTreeBuilder node, Field field, String name) throws FiberException {
        ConfigTreeBuilder sub = node.fork(name);
        try {
            field.setAccessible(true);
            this.applyToNode(sub, field.get(pojo));
            this.applyAnnotationProcessors(pojo, field, sub, this.groupSettingProcessors);
            sub.build();
        }
        catch (IllegalAccessException e) {
            throw new FiberException("Couldn't fork and apply sub-node", e);
        }
    }

    private <T> void fieldToItem(ConfigTreeBuilder node, Field field, Object pojo, String name, List<Member> listeners) throws FiberException {
        Class<T> type = this.getSettingTypeFromField(field);
        ConfigLeafBuilder<Object> builder = this.createConfigLeafBuilder(node, name, type, field, pojo).withComment(this.findComment(field)).withDefaultValue(this.findDefaultValue(field, pojo)).withFinality(this.getSettingAnnotation(field).map(Setting::constant).orElse(false));
        this.constrain(builder.beginConstraints(), field.getAnnotatedType(), pojo).finishConstraints();
        for (Member listener : listeners) {
            BiConsumer<T, T> consumer = this.constructListener(listener, pojo, type);
            if (consumer == null) continue;
            builder.withListener(consumer);
        }
        builder.withListener((t, newValue) -> {
            try {
                field.setAccessible(true);
                field.set(pojo, newValue);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        this.applyAnnotationProcessors(pojo, field, builder, this.valueSettingProcessors);
        builder.build();
    }

    private <C> void applyAnnotationProcessors(Object pojo, Field field, C sub, Map<Class<? extends Annotation>, ? extends SettingAnnotationProcessor<?, C>> settingProcessors) {
        for (Annotation annotation : field.getAnnotations()) {
            SettingAnnotationProcessor<?, C> processor = settingProcessors.get(annotation.annotationType());
            if (processor == null) continue;
            processor.apply(annotation, field, pojo, sub);
        }
    }

    @Nonnull
    private <T, E> ConfigLeafBuilder<T> createConfigLeafBuilder(ConfigTreeBuilder parent, String name, Class<T> type, Field field, Object pojo) {
        AnnotatedType annotatedType = field.getAnnotatedType();
        if (ConfigAggregateBuilder.isAggregate(type)) {
            if (Collection.class.isAssignableFrom(type)) {
                if (annotatedType instanceof AnnotatedParameterizedType) {
                    AnnotatedType typeArg;
                    Class<?> componentType;
                    AnnotatedType[] typeArgs = ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments();
                    if (typeArgs.length == 1 && (componentType = TypeMagic.classForType((typeArg = typeArgs[0]).getType())) != null) {
                        ConfigAggregateBuilder<E[], ?> aggregate = ConfigAggregateBuilder.create(parent, name, type, componentType);
                        this.constrain(((AggregateConstraintsBuilder)aggregate.beginConstraints()).component(), typeArg, pojo).finishComponent().finishConstraints();
                        return aggregate;
                    }
                    return ConfigAggregateBuilder.create(parent, name, type, null);
                }
            } else {
                assert (type.isArray());
                if (annotatedType instanceof AnnotatedArrayType) {
                    Class<E[]> arrayType = type;
                    ConfigAggregateBuilder aggregate = ConfigAggregateBuilder.create(parent, name, arrayType);
                    this.constrain(((AggregateConstraintsBuilder)aggregate.beginConstraints()).component(), ((AnnotatedArrayType)annotatedType).getAnnotatedGenericComponentType(), pojo).finishComponent().finishConstraints();
                    return aggregate;
                }
            }
        }
        return new ConfigLeafBuilder<T>(parent, name, type);
    }

    private <T, B extends AbstractConstraintsBuilder<?, T, ?>> B constrain(B constraints, AnnotatedElement annotated, Object pojo) {
        for (Annotation annotation : annotated.getAnnotations()) {
            ConstraintProcessorEntry entry = this.constraintProcessors.get(annotation.annotationType());
            if (entry == null) continue;
            if (constraints.getType() == null || entry.acceptedType.isAssignableFrom(constraints.getType())) {
                entry.processor.apply(annotation, annotated, pojo, constraints);
                continue;
            }
            throw new RuntimeFiberException(annotation + " does not support " + (annotated instanceof AnnotatedType ? TypeMagic.classForType(((AnnotatedType)annotated).getType()) : (annotated instanceof Field ? ((Field)annotated).getType().getName() : annotated)) + ". Should be assignable to " + entry.acceptedType.getName() + ".");
        }
        return constraints;
    }

    private <T> T findDefaultValue(Field field, Object pojo) throws FiberException {
        Object value;
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            value = field.get(pojo);
        }
        catch (IllegalAccessException e) {
            throw new FiberException("Couldn't get value for field '" + field.getName() + "'", e);
        }
        field.setAccessible(accessible);
        return (T)value;
    }

    private <T, P, A> BiConsumer<T, T> constructListener(Member listener, P pojo, Class<A> wantedType) throws FiberException {
        if (listener instanceof Field) {
            return this.constructListenerFromField((Field)listener, pojo, wantedType);
        }
        if (listener instanceof Method) {
            return this.constructListenerFromMethod((Method)listener, pojo, wantedType);
        }
        throw new FiberException("Cannot create listener from " + listener + ": must be a field or method");
    }

    private <T, P, A> BiConsumer<T, T> constructListenerFromMethod(Method method, P pojo, Class<A> wantedType) throws FiberException {
        int i = this.checkListenerMethod(method, wantedType);
        method.setAccessible(true);
        boolean staticMethod = Modifier.isStatic(method.getModifiers());
        switch (i) {
            case 1: {
                return (oldValue, newValue) -> {
                    try {
                        method.invoke(staticMethod ? null : pojo, newValue);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                };
            }
            case 2: {
                return (oldValue, newValue) -> {
                    try {
                        method.invoke(staticMethod ? null : pojo, oldValue, newValue);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                };
            }
        }
        throw new FiberException("Listener failed due to an invalid number of arguments.");
    }

    private <A> int checkListenerMethod(Method method, Class<A> wantedType) throws FiberException {
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new FiberException("Listener method must return void");
        }
        int paramCount = method.getParameterCount();
        if (paramCount != 1 && paramCount != 2 || !method.getParameterTypes()[0].equals(wantedType)) {
            throw new FiberException("Listener method must have exactly two parameters of type that it listens for");
        }
        return paramCount;
    }

    private <T, P, A> BiConsumer<T, T> constructListenerFromField(Field field, P pojo, Class<A> wantedType) throws FiberException {
        BiConsumer consumer;
        this.checkListenerField(field, wantedType);
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        try {
            BiConsumer biConsumer = consumer = (BiConsumer)field.get(pojo);
        }
        catch (IllegalAccessException e) {
            throw new FiberException("Couldn't construct listener", e);
        }
        field.setAccessible(isAccessible);
        return consumer;
    }

    private <A> void checkListenerField(Field field, Class<A> wantedType) throws MalformedFieldException {
        if (!field.getType().equals(BiConsumer.class)) {
            throw new MalformedFieldException("Field " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must be a BiConsumer");
        }
        ParameterizedType genericTypes = (ParameterizedType)field.getGenericType();
        if (genericTypes.getActualTypeArguments().length != 2) {
            throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have 2 generic types");
        }
        if (genericTypes.getActualTypeArguments()[0] != genericTypes.getActualTypeArguments()[1]) {
            throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have 2 identical generic types");
        }
        if (!genericTypes.getActualTypeArguments()[0].equals(wantedType)) {
            throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have the same generic type as the field it's listening for");
        }
    }

    private <T> Class<T> getSettingTypeFromField(Field field) {
        Class<?> type = field.getType();
        return AnnotatedSettings.wrapPrimitive(type);
    }

    public static <T> Class<T> wrapPrimitive(Class<T> type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        return type;
    }

    private String findComment(Field field) {
        return this.getSettingAnnotation(field).map(Setting::comment).filter(s -> !s.isEmpty()).orElse(null);
    }

    private String findName(Field field, SettingNamingConvention convention) {
        return Optional.ofNullable(field.isAnnotationPresent(Setting.Group.class) ? field.getAnnotation(Setting.Group.class).name() : (String)this.getSettingAnnotation(field).map(Setting::name).orElse(null)).filter(s -> !s.isEmpty()).orElse(convention.name(field.getName()));
    }

    private SettingNamingConvention createConvention(Class<? extends SettingNamingConvention> namingConvention) throws FiberException {
        try {
            return namingConvention.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FiberException("Could not initialise naming convention", e);
        }
    }

    private static class ConstraintProcessorEntry {
        private final ConstraintAnnotationProcessor processor;
        private final Class<?> acceptedType;

        ConstraintProcessorEntry(ConstraintAnnotationProcessor<?, ?> processor, Class<?> acceptedType) {
            this.processor = processor;
            this.acceptedType = acceptedType;
        }
    }
}

