/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.api.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.api.FiberId;
import me.zeroeightsix.fiber.api.annotation.AnnotatedSettings;
import me.zeroeightsix.fiber.api.builder.ConfigTreeBuilder;
import me.zeroeightsix.fiber.api.builder.constraint.ConstraintsBuilder;
import me.zeroeightsix.fiber.api.constraint.Constraint;
import me.zeroeightsix.fiber.api.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.api.tree.ConfigLeaf;
import me.zeroeightsix.fiber.api.tree.ConfigNode;
import me.zeroeightsix.fiber.impl.builder.ConfigNodeBuilder;
import me.zeroeightsix.fiber.impl.constraint.FinalConstraint;
import me.zeroeightsix.fiber.impl.tree.ConfigLeafImpl;

public class ConfigLeafBuilder<T>
extends ConfigNodeBuilder {
    @Nonnull
    protected final Class<T> type;
    @Nullable
    private T defaultValue = null;
    private boolean isFinal = false;
    private BiConsumer<T, T> consumer = (t, t2) -> {};
    protected List<Constraint<? super T>> constraintList = new ArrayList<Constraint<? super T>>();

    public ConfigLeafBuilder(ConfigTreeBuilder parentNode, @Nonnull String name, @Nonnull Class<T> type) {
        super(parentNode, name);
        this.type = AnnotatedSettings.wrapPrimitive(type);
    }

    @Nonnull
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public ConfigLeafBuilder<T> withName(@Nonnull String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ConfigLeafBuilder<T> withComment(String comment) {
        super.withComment(comment);
        return this;
    }

    @Override
    public <A> ConfigLeafBuilder<T> withAttribute(FiberId id, Class<A> type, A defaultValue) {
        super.withAttribute(id, type, defaultValue);
        return this;
    }

    public ConfigLeafBuilder<T> withListener(BiConsumer<T, T> consumer) {
        BiConsumer prevConsumer = this.consumer;
        this.consumer = (t, t2) -> {
            prevConsumer.accept(t, t2);
            consumer.accept(t, t2);
        };
        return this;
    }

    public ConfigLeafBuilder<T> withDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ConfigLeafBuilder<T> withFinality() {
        this.isFinal = true;
        return this;
    }

    public ConfigLeafBuilder<T> withFinality(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    public ConstraintsBuilder<T> beginConstraints() {
        return new ConstraintsBuilder<T>(this, this.constraintList, this.type);
    }

    @Override
    public ConfigLeaf<T> build() {
        if (this.defaultValue != null) {
            for (Constraint<T> constraint : this.constraintList) {
                if (constraint.test(this.defaultValue)) continue;
                throw new RuntimeFiberException("Default value '" + this.defaultValue + "' does not satisfy constraints");
            }
        }
        ArrayList<Constraint<T>> constraints = new ArrayList<Constraint<T>>(this.constraintList);
        if (this.isFinal) {
            constraints.add(0, FinalConstraint.instance());
        }
        ConfigLeafImpl<T> built = new ConfigLeafImpl<T>(Objects.requireNonNull(this.name, "Cannot build a value without a name"), this.comment, this.defaultValue, this.consumer, constraints, this.type);
        built.getAttributes().putAll(this.attributes);
        if (this.parent != null) {
            try {
                this.parent.getItems().add(built);
            }
            catch (RuntimeFiberException e) {
                throw new RuntimeFiberException("Failed to register leaf to node", e);
            }
        }
        return built;
    }

    public ConfigTreeBuilder finishValue() {
        return this.finishValue(n -> {});
    }

    public ConfigTreeBuilder finishValue(Consumer<ConfigLeaf<T>> action) {
        if (this.parent instanceof ConfigTreeBuilder) {
            action.accept((ConfigLeaf<ConfigNode>)this.build());
            return (ConfigTreeBuilder)this.parent;
        }
        throw new IllegalStateException("finishValue should not be called for an independent builder. Use build instead.");
    }
}

