/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.api.serialization;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.SyntaxError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.api.FiberId;
import me.zeroeightsix.fiber.api.exception.FiberException;
import me.zeroeightsix.fiber.api.serialization.Marshaller;
import me.zeroeightsix.fiber.api.serialization.Serializer;
import me.zeroeightsix.fiber.api.tree.Commentable;
import me.zeroeightsix.fiber.api.tree.ConfigBranch;
import me.zeroeightsix.fiber.api.tree.ConfigNode;
import me.zeroeightsix.fiber.api.tree.ConfigTree;
import me.zeroeightsix.fiber.api.tree.HasValue;
import me.zeroeightsix.fiber.api.tree.Property;

public class JanksonSerializer
implements Serializer<JsonObject> {
    private static final FiberId IDENTIFIER = new FiberId("fiber", "jankson");
    private final boolean compress;
    @Nonnull
    private final Marshaller<JsonElement> marshaller;

    public JanksonSerializer() {
        this(JanksonFallbackMarshaller.INSTANCE, false);
    }

    public JanksonSerializer(@Nonnull Marshaller<JsonElement> marshaller, boolean compress) {
        this.compress = compress;
        this.marshaller = marshaller;
    }

    @Override
    public JsonObject deserialize(ConfigTree tree, InputStream stream) throws IOException, FiberException {
        JsonObject object;
        Jankson jankson = Jankson.builder().build();
        try {
            object = jankson.load(stream);
        }
        catch (SyntaxError syntaxError) {
            throw new FiberException("Configuration file was malformed", syntaxError);
        }
        return this.deserialize(tree, object);
    }

    @Override
    public JsonObject deserialize(ConfigTree tree, JsonObject element) throws FiberException {
        JsonObject leftovers = new JsonObject();
        for (Map.Entry<String, JsonElement> entry : element.entrySet()) {
            String key = entry.getKey();
            JsonElement child = entry.getValue();
            ConfigNode item = tree.lookup(key);
            if (item != null) {
                if (item instanceof Property) {
                    this.setPropertyValue((Property)((Object)item), child);
                    continue;
                }
                if (item instanceof ConfigBranch && child instanceof JsonObject) {
                    JsonObject childLeftovers = this.deserialize((ConfigTree)((Object)item), (JsonObject)child);
                    if (childLeftovers.isEmpty()) continue;
                    leftovers.put(key, childLeftovers);
                    continue;
                }
                throw new FiberException("Value read for non-property node: " + item.getName());
            }
            leftovers.put(key, child);
        }
        return leftovers;
    }

    private JsonElement serialize(HasValue<?> hasValue) {
        return this.marshaller.marshall(hasValue.getValue());
    }

    @Override
    public void serialize(ConfigTree tree, @Nullable JsonObject additionalData, OutputStream out) throws IOException {
        JsonObject object = this.serialize(tree);
        if (additionalData != null) {
            object.putAll(additionalData);
        }
        out.write(object.toJson(!this.compress, !this.compress).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public JsonObject serialize(ConfigTree tree) {
        JsonObject object = new JsonObject();
        for (ConfigNode treeItem : tree.getItems()) {
            String name = null;
            if (treeItem instanceof ConfigBranch) {
                ConfigBranch subNode = (ConfigBranch)treeItem;
                if (!subNode.isSerializedSeparately()) {
                    name = subNode.getName();
                    object.put(name, this.serialize(subNode));
                }
            } else if (treeItem instanceof HasValue) {
                name = treeItem.getName();
                object.put(name, this.serialize((HasValue)((Object)treeItem)));
            }
            if (name == null || !(treeItem instanceof Commentable)) continue;
            object.setComment(name, ((Commentable)((Object)treeItem)).getComment());
        }
        return object;
    }

    private <A> A marshall(Class<A> type, JsonElement value) {
        return this.marshaller.marshallReverse(type, value);
    }

    private <T> void setPropertyValue(Property<T> property, JsonElement child) {
        Class type = property.getType();
        property.setValue(this.marshall(type, child));
    }

    @Override
    public FiberId getIdentifier() {
        return IDENTIFIER;
    }

    public static Marshaller<JsonElement> extendDefaultMarshaller(final Marshaller<JsonElement> marshaller) {
        return new Marshaller<JsonElement>(){

            @Override
            public JsonElement marshall(Object value) {
                JsonElement object = (JsonElement)marshaller.marshall(value);
                if (object == null) {
                    return JanksonFallbackMarshaller.INSTANCE.marshall(value);
                }
                return object;
            }

            @Override
            public <A> A marshallReverse(Class<A> type, JsonElement value) {
                A object = marshaller.marshallReverse(type, value);
                if (object == null) {
                    return JanksonFallbackMarshaller.INSTANCE.marshallReverse(type, value);
                }
                return object;
            }
        };
    }

    private static class JanksonFallbackMarshaller
    implements Marshaller<JsonElement> {
        private static final JanksonFallbackMarshaller INSTANCE = new JanksonFallbackMarshaller();
        private final blue.endless.jankson.api.Marshaller marshaller = Jankson.builder().build().getMarshaller();

        private JanksonFallbackMarshaller() {
        }

        @Override
        public JsonElement marshall(Object value) {
            return this.marshaller.serialize(value);
        }

        @Override
        public <A> A marshallReverse(Class<A> type, JsonElement value) {
            return this.marshaller.marshall(type, value);
        }
    }
}

