/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.impl.tree;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.api.FiberId;
import me.zeroeightsix.fiber.api.exception.IllegalTreeStateException;
import me.zeroeightsix.fiber.api.tree.Commentable;
import me.zeroeightsix.fiber.api.tree.ConfigAttribute;
import me.zeroeightsix.fiber.api.tree.ConfigBranch;
import me.zeroeightsix.fiber.api.tree.ConfigNode;
import me.zeroeightsix.fiber.impl.tree.ConfigAttributeImpl;

public abstract class ConfigNodeImpl
implements ConfigNode,
Commentable {
    private final Map<FiberId, ConfigAttribute<?>> attributes = new TreeMap(Comparator.comparing(FiberId::toString));
    @Nonnull
    private final String name;
    @Nullable
    private final String comment;
    @Nullable
    private ConfigBranch parent;

    public ConfigNodeImpl(@Nonnull String name, @Nullable String comment) {
        this.name = name;
        this.comment = comment;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Override
    @Nullable
    public ConfigBranch getParent() {
        return this.parent;
    }

    @Override
    public Map<FiberId, ConfigAttribute<?>> getAttributes() {
        return this.attributes;
    }

    @Override
    public <A> ConfigAttribute<A> getOrCreateAttribute(FiberId id, Class<A> attributeType, @Nullable A defaultValue) {
        ConfigAttribute attr = this.getAttributes().computeIfAbsent(id, i -> new ConfigAttributeImpl<Object>(attributeType, defaultValue));
        ConfigNodeImpl.checkAttributeType(attributeType, attr);
        return attr;
    }

    @Override
    public <A> Optional<A> getAttributeValue(FiberId id, Class<A> expectedType) {
        ConfigAttribute<?> attr = this.attributes.get(id);
        if (attr != null) {
            ConfigNodeImpl.checkAttributeType(expectedType, attr);
            return Optional.ofNullable(expectedType.cast(attr.getValue()));
        }
        return Optional.empty();
    }

    private static <A> void checkAttributeType(Class<A> expectedType, ConfigAttribute<?> attr) {
        if (!expectedType.isAssignableFrom(attr.getType())) {
            throw new ClassCastException("Attempt to retrieve a value of type " + expectedType + " from attribute with type " + attr.getType());
        }
    }

    @Override
    public void detach() {
        if (this.parent != null) {
            this.parent.getItems().remove(this);
        }
        this.parent = null;
    }

    @Override
    public void attachTo(ConfigBranch parent) {
        if (this.parent != null && this.parent != parent) {
            throw new IllegalTreeStateException(this + " needs to be detached before changing the parent");
        }
        if (parent != null && !parent.getItems().contains(this)) {
            parent.getItems().add(this);
        }
        this.parent = parent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", comment=" + this.getComment() + "]";
    }
}

