/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.api;

import java.util.Iterator;
import me.zeroeightsix.fiber.api.exception.DuplicateChildException;
import me.zeroeightsix.fiber.api.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.api.tree.ConfigNode;
import me.zeroeightsix.fiber.api.tree.ConfigTree;
import me.zeroeightsix.fiber.api.tree.Property;

public class NodeOperations {
    public static void moveChildren(ConfigTree from, ConfigTree to) {
        try {
            Iterator it = from.getItems().iterator();
            while (it.hasNext()) {
                ConfigNode item = (ConfigNode)it.next();
                it.remove();
                to.getItems().add(item, true);
            }
        }
        catch (DuplicateChildException e) {
            throw new RuntimeFiberException("Failed to merge nodes", e);
        }
    }

    public static void moveNode(ConfigNode value, ConfigTree to) {
        try {
            value.detach();
            to.getItems().add(value, true);
        }
        catch (DuplicateChildException e) {
            throw new RuntimeFiberException("Failed to merge value", e);
        }
    }

    public static <T> void copyValue(Property<T> from, Property<T> to) {
        to.setValue(from.getValue());
    }
}

