/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.api.constraint;

import me.zeroeightsix.fiber.api.FiberId;

public enum ConstraintType {
    FINAL(false, ConstraintType.identifier("final")),
    NUMERICAL_LOWER_BOUND(true, ConstraintType.identifier("min")),
    NUMERICAL_UPPER_BOUND(true, ConstraintType.identifier("max")),
    MINIMUM_LENGTH(true, ConstraintType.identifier("min_length")),
    MAXIMUM_LENGTH(true, ConstraintType.identifier("max_length")),
    STRING_MATCHING(false, ConstraintType.identifier("regex")),
    COMPONENTS_MATCH(false, ConstraintType.identifier("component")),
    COMPOSITE(false, ConstraintType.identifier("composite"));

    private final boolean numerical;
    private final FiberId identifier;

    private ConstraintType(boolean numerical, FiberId identifier) {
        this.numerical = numerical;
        this.identifier = identifier;
    }

    private static FiberId identifier(String name) {
        return new FiberId("fiber", name);
    }

    public boolean isNumerical() {
        return this.numerical;
    }

    public FiberId getIdentifier() {
        return this.identifier;
    }
}

