/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.api.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.api.FiberId;
import me.zeroeightsix.fiber.api.annotation.AnnotatedSettings;
import me.zeroeightsix.fiber.api.builder.ConfigAggregateBuilder;
import me.zeroeightsix.fiber.api.builder.ConfigLeafBuilder;
import me.zeroeightsix.fiber.api.exception.DuplicateChildException;
import me.zeroeightsix.fiber.api.exception.FiberException;
import me.zeroeightsix.fiber.api.exception.IllegalTreeStateException;
import me.zeroeightsix.fiber.api.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.api.tree.ConfigBranch;
import me.zeroeightsix.fiber.api.tree.ConfigNode;
import me.zeroeightsix.fiber.api.tree.ConfigTree;
import me.zeroeightsix.fiber.api.tree.NodeCollection;
import me.zeroeightsix.fiber.impl.builder.ConfigNodeBuilder;
import me.zeroeightsix.fiber.impl.tree.ConfigBranchImpl;
import me.zeroeightsix.fiber.impl.tree.ConfigLeafImpl;
import me.zeroeightsix.fiber.impl.tree.IndexedNodeCollection;

public class ConfigTreeBuilder
extends ConfigNodeBuilder
implements ConfigTree {
    private final NodeCollection items = new IndexedNodeCollection(null);
    @Nullable
    private String name;
    @Nullable
    private String comment;
    private boolean serializeSeparately;

    public ConfigTreeBuilder(@Nullable ConfigTree parent, @Nullable String name) {
        super(parent, name);
        this.parent = parent;
        this.name = name;
    }

    @Override
    @Nonnull
    public NodeCollection getItems() {
        return this.items;
    }

    @Override
    @Nullable
    public ConfigNode lookup(String name) {
        return this.items.getByName(name);
    }

    public ConfigTreeBuilder withParent(ConfigTreeBuilder parent) {
        if (this.name == null && parent != null) {
            throw new IllegalStateException("A child node needs a name");
        }
        this.parent = parent;
        return this;
    }

    @Override
    public ConfigTreeBuilder withName(String name) {
        if (name == null && this.parent != null) {
            throw new IllegalStateException("Cannot remove the name from a child node");
        }
        this.name = name;
        return this;
    }

    @Override
    public ConfigTreeBuilder withComment(@Nullable String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public <A> ConfigTreeBuilder withAttribute(FiberId id, Class<A> type, A defaultValue) {
        super.withAttribute(id, type, defaultValue);
        return this;
    }

    public ConfigTreeBuilder withSeparateSerialization() {
        this.withSeparateSerialization(true);
        return this;
    }

    public ConfigTreeBuilder withSeparateSerialization(boolean serializeSeparately) {
        this.serializeSeparately = serializeSeparately;
        return this;
    }

    public ConfigTreeBuilder applyFromPojo(Object pojo) throws FiberException {
        return this.applyFromPojo(pojo, AnnotatedSettings.DEFAULT_SETTINGS);
    }

    public ConfigTreeBuilder applyFromPojo(Object pojo, AnnotatedSettings settings) throws FiberException {
        settings.applyToNode(this, pojo);
        return this;
    }

    public <T> ConfigLeafBuilder<T> beginValue(@Nonnull String name, @Nonnull Class<T> type, @Nullable T defaultValue) {
        return new ConfigLeafBuilder<T>(this, name, type).withDefaultValue(defaultValue);
    }

    public <T> ConfigTreeBuilder withValue(@Nonnull String name, @Nonnull Class<T> type, @Nullable T defaultValue) {
        this.items.add(new ConfigLeafImpl(name, null, defaultValue, (a, b) -> {}, Collections.emptyList(), type));
        return this;
    }

    public <E> ConfigAggregateBuilder<E[], E> beginAggregateValue(@Nonnull String name, @Nonnull E[] defaultValue) {
        Class<E[]> type = defaultValue.getClass();
        return ConfigAggregateBuilder.create(this, name, type).withDefaultValue(defaultValue);
    }

    public <E> ConfigAggregateBuilder<List<E>, E> beginListValue(@Nonnull String name, Class<E> elementType, E ... defaultValues) {
        return this.beginAggregateValue(name, List.class, elementType, Collections.unmodifiableList(Arrays.asList(defaultValues)));
    }

    public <E> ConfigAggregateBuilder<Set<E>, E> beginSetValue(@Nonnull String name, Class<E> elementType, E ... defaultElements) {
        return this.beginAggregateValue(name, Set.class, elementType, Collections.unmodifiableSet(new HashSet<E>(Arrays.asList(defaultElements))));
    }

    public <C extends Collection<E>, E> ConfigAggregateBuilder<C, E> beginAggregateValue(@Nonnull String name, @Nonnull Class<? super C> collectionType, @Nullable Class<E> elementType, @Nonnull C defaultValue) {
        return ConfigAggregateBuilder.create(this, name, collectionType, elementType).withDefaultValue((Object)defaultValue);
    }

    public ConfigTreeBuilder withChild(@Nonnull ConfigNode item) throws DuplicateChildException {
        this.items.add(item);
        return this;
    }

    public ConfigTreeBuilder withChild(@Nonnull ConfigNode item, boolean overwrite) throws DuplicateChildException {
        this.items.add(item, overwrite);
        return this;
    }

    public ConfigTreeBuilder fork(String name) {
        return new ConfigTreeBuilder(this, name);
    }

    @Override
    public ConfigBranch build() throws RuntimeFiberException {
        try {
            ConfigBranchImpl built = new ConfigBranchImpl(this.name, this.comment, this.items, this.serializeSeparately);
            built.getAttributes().putAll(this.attributes);
            if (this.parent != null) {
                assert (this.name != null);
                this.parent.getItems().add(built);
            }
            return built;
        }
        catch (IllegalTreeStateException e) {
            throw new RuntimeFiberException("Failed to build branch '" + this.name + "'", e);
        }
    }

    public ConfigTreeBuilder finishBranch() {
        return this.finishBranch(n -> {});
    }

    public ConfigTreeBuilder finishBranch(Consumer<ConfigBranch> action) {
        if (this.parent instanceof ConfigTreeBuilder) {
            action.accept(this.build());
            return (ConfigTreeBuilder)this.parent;
        }
        throw new IllegalStateException("finishNode should not be called for a root builder. Use build instead.");
    }
}

