/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.impl.tree;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.api.tree.ConfigBranch;
import me.zeroeightsix.fiber.api.tree.ConfigNode;
import me.zeroeightsix.fiber.api.tree.NodeCollection;
import me.zeroeightsix.fiber.impl.tree.ConfigNodeImpl;
import me.zeroeightsix.fiber.impl.tree.IndexedNodeCollection;

public class ConfigBranchImpl
extends ConfigNodeImpl
implements ConfigBranch {
    private final NodeCollection items = new IndexedNodeCollection(this);
    private final boolean serializeSeparately;

    public ConfigBranchImpl(String name, @Nullable String comment, @Nonnull Collection<ConfigNode> items, boolean serializeSeparately) {
        super(name, comment);
        this.serializeSeparately = serializeSeparately;
        this.items.addAll(items);
    }

    public ConfigBranchImpl(@Nonnull String name, @Nullable String comment) {
        this(name, comment, Collections.emptyList(), false);
    }

    public ConfigBranchImpl() {
        this(null, null, Collections.emptyList(), false);
    }

    @Override
    @Nonnull
    public NodeCollection getItems() {
        return this.items;
    }

    @Override
    @Nullable
    public ConfigNode lookup(String name) {
        return this.items.getByName(name);
    }

    @Override
    public boolean isSerializedSeparately() {
        return this.serializeSeparately;
    }
}

