/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.impl.constraint;

import java.math.BigDecimal;
import me.zeroeightsix.fiber.api.constraint.ConstraintType;
import me.zeroeightsix.fiber.api.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.impl.constraint.ValuedConstraint;

public class NumberConstraint<T extends Number>
extends ValuedConstraint<T, T> {
    public NumberConstraint(ConstraintType type, T value) throws RuntimeFiberException {
        super(type, value);
        if (!type.isNumerical()) {
            throw new RuntimeFiberException("Couldn't create numerical constraint: type must be numerical");
        }
    }

    @Override
    public boolean test(T value) {
        int compared = new BigDecimal(((Number)this.getValue()).toString()).compareTo(new BigDecimal(value.toString()));
        switch (this.getType()) {
            case NUMERICAL_LOWER_BOUND: {
                return compared <= 0;
            }
            case NUMERICAL_UPPER_BOUND: {
                return compared >= 0;
            }
        }
        throw new RuntimeFiberException("A NumberConstraint must be of type NUMERICAL_LOWER_BOUND or NUMERICAL_UPPER_BOUND");
    }
}

