/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.api.builder.constraint;

import java.util.List;
import me.zeroeightsix.fiber.api.builder.constraint.AbstractConstraintsBuilder;
import me.zeroeightsix.fiber.api.constraint.CompositeType;
import me.zeroeightsix.fiber.api.constraint.Constraint;
import me.zeroeightsix.fiber.api.constraint.ConstraintType;
import me.zeroeightsix.fiber.api.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.impl.constraint.ValuedConstraint;

public final class CompositeConstraintsBuilder<S, T>
extends AbstractConstraintsBuilder<S, T, T> {
    private final CompositeType compositeType;

    public CompositeConstraintsBuilder(S source, CompositeType compositeType, List<Constraint<? super T>> sourceConstraints, Class<T> type) {
        super(source, sourceConstraints, type);
        this.compositeType = compositeType;
    }

    public CompositeConstraintsBuilder<S, T> atLeast(T min) throws RuntimeFiberException {
        super.atLeast(min);
        return this;
    }

    public CompositeConstraintsBuilder<S, T> atMost(T max) {
        super.atMost(max);
        return this;
    }

    public CompositeConstraintsBuilder<S, T> range(T min, T max) {
        super.range(min, max);
        return this;
    }

    public CompositeConstraintsBuilder<S, T> minLength(int min) {
        super.minLength(min);
        return this;
    }

    public CompositeConstraintsBuilder<S, T> maxLength(int max) {
        super.maxLength(max);
        return this;
    }

    public CompositeConstraintsBuilder<S, T> regex(String regexPattern) {
        super.regex(regexPattern);
        return this;
    }

    public S finishComposite() {
        this.sourceConstraints.add(this.createConstraint(this.newConstraints));
        return (S)this.source;
    }

    private AbstractCompositeConstraint<T> createConstraint(List<Constraint<? super T>> constraints) {
        switch (this.compositeType) {
            case OR: {
                return new OrCompositeConstraint<T>(constraints);
            }
            case AND: {
                return new AndCompositeConstraint<T>(constraints);
            }
            case INVERT: {
                return new InvertCompositeConstraint<T>(constraints);
            }
        }
        throw new AssertionError();
    }

    private static final class InvertCompositeConstraint<T>
    extends AbstractCompositeConstraint<T> {
        public InvertCompositeConstraint(List<Constraint<? super T>> constraints) {
            super(CompositeType.INVERT, constraints);
        }

        @Override
        public boolean test(T value) {
            return this.constraints.stream().noneMatch(constraint -> constraint.test(value));
        }
    }

    private static final class OrCompositeConstraint<T>
    extends AbstractCompositeConstraint<T> {
        public OrCompositeConstraint(List<Constraint<? super T>> constraints) {
            super(CompositeType.OR, constraints);
        }

        @Override
        public boolean test(T value) {
            return this.constraints.stream().anyMatch(constraint -> constraint.test(value));
        }
    }

    private static final class AndCompositeConstraint<T>
    extends AbstractCompositeConstraint<T> {
        public AndCompositeConstraint(List<Constraint<? super T>> constraints) {
            super(CompositeType.AND, constraints);
        }

        @Override
        public boolean test(T value) {
            return this.constraints.stream().allMatch(constraint -> constraint.test(value));
        }
    }

    public static abstract class AbstractCompositeConstraint<T>
    extends ValuedConstraint<String, T> {
        public final List<Constraint<? super T>> constraints;

        public AbstractCompositeConstraint(CompositeType type, List<Constraint<? super T>> constraints) {
            super(ConstraintType.COMPOSITE, type.getName());
            this.constraints = constraints;
        }
    }
}

