/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.impl.annotation.magic;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.annotation.Nullable;

public final class TypeMagic {
    @Nullable
    public static Class<?> classForType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            Type subtype = ((ParameterizedType)t).getRawType();
            if (subtype instanceof Class) {
                return (Class)subtype;
            }
            String className = t.getTypeName();
            int typeParamStart = className.indexOf(60);
            if (typeParamStart >= 0) {
                className = className.substring(0, typeParamStart);
            }
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (t instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)t).getUpperBounds();
            if (upperBounds.length == 0) {
                return Object.class;
            }
            return TypeMagic.classForType(upperBounds[0]);
        }
        if (t instanceof TypeVariable) {
            return Object.class;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)t;
            Class<?> componentClass = TypeMagic.classForType(arrayType.getGenericComponentType());
            try {
                assert (componentClass != null);
                return Class.forName("[L" + componentClass.getCanonicalName() + ";");
            }
            catch (ClassNotFoundException ex2) {
                return Object[].class;
            }
        }
        return null;
    }
}

