/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.impl.Marshaller;
import blue.endless.jankson.impl.SyntaxError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.exceptions.FiberException;
import me.zeroeightsix.fiber.tree.HasValue;
import me.zeroeightsix.fiber.tree.Node;
import me.zeroeightsix.fiber.tree.Property;
import me.zeroeightsix.fiber.tree.Transparent;
import me.zeroeightsix.fiber.tree.TreeItem;

public class JanksonSettings {
    public static void deserialize(Node node, InputStream stream) throws IOException, FiberException {
        JsonObject object;
        Jankson jankson = Jankson.builder().build();
        try {
            object = jankson.load(stream);
        }
        catch (SyntaxError syntaxError) {
            throw new FiberException("Configuration file was malformed", syntaxError);
        }
        JanksonSettings.deserialize(node, object);
    }

    private static void deserialize(Node node, JsonObject element) throws FiberException {
        JsonObject object = element;
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            String key = entry.getKey();
            JsonElement child = entry.getValue();
            TreeItem item = node.lookup(key);
            if (item != null) {
                if (item instanceof Property) {
                    Property property = (Property)((Object)item);
                    Class type = property.getType();
                    property.setValue(Marshaller.getFallback().marshall(type, child));
                    continue;
                }
                throw new FiberException("Value read for non-property node: " + item.getName());
            }
            JanksonTransparentNode transparentNode = new JanksonTransparentNode(key, child);
            node.add(transparentNode);
        }
    }

    public static void serialize(Node node, OutputStream stream, boolean compress) throws IOException {
        JsonObject object = JanksonSettings.serialize(node);
        stream.write(object.toJson(!compress, !compress).getBytes());
    }

    private static JsonObject serialize(Node node) {
        JsonObject object = new JsonObject();
        node.getItems().forEach(treeItem -> {
            if (treeItem instanceof Node) {
                Node subNode = (Node)treeItem;
                object.put(subNode.getName(), JanksonSettings.serialize(subNode));
                return;
            }
            if (treeItem instanceof HasValue) {
                object.put(treeItem.getName(), JanksonSettings.serialize((HasValue)((Object)treeItem)));
            }
        });
        return object;
    }

    private static JsonElement serialize(HasValue hasValue) {
        return Marshaller.getFallback().serialize(hasValue.getValue());
    }

    private static class JanksonTransparentNode
    implements Transparent {
        private final String name;
        private final JsonElement value;

        public JanksonTransparentNode(String name, JsonElement value) {
            this.name = name;
            this.value = value;
        }

        @Override
        @Nullable
        public <A> A marshal(Class<A> type) {
            return Marshaller.getFallback().marshall(type, this.value);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[name=" + this.getName() + "]";
        }
    }
}

