/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.tree;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.exceptions.FiberException;
import me.zeroeightsix.fiber.tree.ConfigNode;
import me.zeroeightsix.fiber.tree.Property;
import me.zeroeightsix.fiber.tree.Transparent;
import me.zeroeightsix.fiber.tree.TreeItem;

public interface Node
extends TreeItem {
    @Nonnull
    public Set<TreeItem> getItems();

    @Nullable
    default public TreeItem lookup(String name) {
        return this.getItems().stream().filter(treeItem -> treeItem.getName().equals(name)).findFirst().orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public TreeItem add(@Nonnull TreeItem item) throws FiberException {
        TreeItem existing = this.lookup(item.getName());
        if (existing == null) {
            this.getItems().add(item);
            return item;
        } else {
            if (!(existing instanceof Transparent)) throw new FiberException("Attempt to replace non-transparent node " + existing.getName());
            if (!(item instanceof Property)) throw new FiberException("Attempt to replace transparent node by non-property node " + item.getName());
            Class type = ((Property)((Object)item)).getType();
            ((Property)((Object)item)).setValue(((Transparent)existing).marshal(type));
            this.getItems().remove(existing);
            this.getItems().add(item);
        }
        return item;
    }

    default public TreeItem remove(String name) {
        Optional<TreeItem> itemOptional = this.getItems().stream().filter(item -> item.getName().equals(name)).findAny();
        if (!itemOptional.isPresent()) {
            return null;
        }
        TreeItem item2 = itemOptional.get();
        this.getItems().remove(item2);
        return item2;
    }

    default public Node fork(String name) throws FiberException {
        return (Node)this.add(new ConfigNode(name, null));
    }
}

