/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived;

import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.processor.ConstraintAnnotationProcessor;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.FiberConversionException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;

public abstract class ConfigType<R, S, T extends SerializableType<S>> {
    private final T serializedType;
    private final Class<R> runtimeType;
    protected final Function<S, R> deserializer;
    protected final Function<R, S> serializer;

    ConfigType(T serializedType, Class<R> runtimeType, Function<S, R> deserializer, Function<R, S> serializer) {
        this.runtimeType = runtimeType;
        this.serializedType = serializedType;
        this.deserializer = deserializer;
        this.serializer = serializer;
    }

    public abstract <U> ConfigType<U, S, T> derive(Class<? super U> var1, Function<R, U> var2, Function<U, R> var3);

    public abstract ConfigType<R, S, T> withType(T var1);

    public S toSerializedType(R runtimeValue) throws FiberConversionException {
        S s = this.toPlatformType(runtimeValue);
        if (!((SerializableType)this.serializedType).accepts(s)) {
            throw new FiberConversionException("Serialized form " + s + "(" + ((SerializableType)this.serializedType).getErasedPlatformType().getSimpleName() + ") of runtime value " + runtimeValue + "(" + this.runtimeType.getSimpleName() + ") does not satisfy constraints for type " + this.serializedType);
        }
        return s;
    }

    public S toPlatformType(R runtimeValue) {
        return this.serializer.apply(Objects.requireNonNull(runtimeValue));
    }

    public R toRuntimeType(S serializedValue) throws FiberConversionException {
        if (!((SerializableType)this.serializedType).accepts(serializedValue)) {
            throw new FiberConversionException("Invalid serialized value " + serializedValue);
        }
        return Objects.requireNonNull(this.deserializer.apply(serializedValue));
    }

    public Class<R> getRuntimeType() {
        return this.runtimeType;
    }

    public T getSerializedType() {
        return this.serializedType;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("serializedType=" + this.serializedType).add("runtimeType=" + this.runtimeType).toString();
    }

    public abstract ConfigType<R, S, T> constrain(ConstraintAnnotationProcessor<Annotation> var1, Annotation var2, AnnotatedElement var3);

    void checkTypeNarrowing(T newSpec) {
        if (!((SerializableType)this.serializedType).isAssignableFrom((SerializableType<?>)newSpec)) {
            throw new IllegalStateException("Cannot widen the constraints on a TypeConverter");
        }
    }
}

