/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.impl.fiber.annotation;

import io.github.fablabsmc.fablabs.api.fiber.v1.NodeOperations;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.AnnotatedSettings;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.Setting;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.SettingNamingConvention;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.Settings;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.collect.MemberCollector;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.collect.PojoMemberProcessor;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.processor.BranchAnnotationProcessor;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.processor.ConfigAnnotationProcessor;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.processor.ConstraintAnnotationProcessor;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.processor.LeafAnnotationProcessor;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.processor.ParameterizedTypeProcessor;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigLeafBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.FiberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.FiberTypeProcessingException;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.MalformedFieldException;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ProcessingMemberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.RuntimeFiberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.EnumConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.impl.fiber.annotation.magic.TypeMagic;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AnnotatedSettingsImpl
implements AnnotatedSettings {
    private final Map<Class<?>, ParameterizedTypeProcessor<?>> registeredGenericTypes;
    private final Map<Class<?>, ConfigType<?, ?, ?>> registeredTypes;
    private final Map<Class<? extends Annotation>, LeafAnnotationProcessor<?>> valueSettingProcessors;
    private final Map<Class<? extends Annotation>, BranchAnnotationProcessor<?>> groupSettingProcessors;
    private final Map<Class<? extends Annotation>, ConstraintAnnotationProcessor<?>> constraintProcessors;
    private final MemberCollector memberCollector;
    private final SettingNamingConvention convention;

    AnnotatedSettingsImpl(Map<Class<?>, ParameterizedTypeProcessor<?>> registeredGenericTypes, Map<Class<?>, ConfigType<?, ?, ?>> registeredTypes, Map<Class<? extends Annotation>, LeafAnnotationProcessor<?>> valueSettingProcessors, Map<Class<? extends Annotation>, BranchAnnotationProcessor<?>> groupSettingProcessors, Map<Class<? extends Annotation>, ConstraintAnnotationProcessor<?>> constraintProcessors, MemberCollector memberCollector, SettingNamingConvention convention) {
        this.registeredGenericTypes = Collections.unmodifiableMap(new LinkedHashMap(registeredGenericTypes));
        this.registeredTypes = Collections.unmodifiableMap(new LinkedHashMap(registeredTypes));
        this.valueSettingProcessors = Collections.unmodifiableMap(new LinkedHashMap(valueSettingProcessors));
        this.groupSettingProcessors = Collections.unmodifiableMap(new LinkedHashMap(groupSettingProcessors));
        this.constraintProcessors = Collections.unmodifiableMap(new LinkedHashMap(constraintProcessors));
        this.memberCollector = memberCollector;
        this.convention = convention;
    }

    @Override
    public ConfigBranch makeTree(Object pojo) throws FiberException {
        ConfigTreeBuilder builder = ConfigTree.builder();
        this.applyToNode(builder, pojo);
        return builder.build();
    }

    @Override
    public <P> void applyToNode(ConfigTree mergeTo, P pojo) throws FiberException {
        Class<?> pojoClass = pojo.getClass();
        SettingNamingConvention convention = AnnotatedSettingsImpl.findSettingAnnotation(Settings.class, pojoClass).map(Settings::namingConvention).map(AnnotatedSettingsImpl::createConvention).orElse(this.convention);
        ConfigTreeBuilder builder = ConfigTree.builder();
        PojoMemberProcessorImpl processor = new PojoMemberProcessorImpl(convention, builder);
        this.memberCollector.collect(pojo, pojoClass, processor);
        NodeOperations.moveChildren(builder, mergeTo);
    }

    private static void checkViolation(Field field) throws FiberException {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new FiberException("Field '" + field.getName() + "' can not be final");
        }
    }

    private static <A extends Annotation> Optional<A> findSettingAnnotation(Class<A> annotationType, AnnotatedElement field) {
        return Optional.ofNullable(field.getAnnotation(annotationType));
    }

    private static SettingNamingConvention createConvention(Class<? extends SettingNamingConvention> namingConvention) {
        try {
            return namingConvention.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeFiberException("Could not initialise naming convention", e);
        }
    }

    private class PojoMemberProcessorImpl
    implements PojoMemberProcessor {
        private final SettingNamingConvention convention;
        private final Map<String, List<Member>> listenerMap = new HashMap<String, List<Member>>();
        private final ConfigTreeBuilder builder;

        PojoMemberProcessorImpl(SettingNamingConvention convention, ConfigTreeBuilder builder) {
            this.convention = convention;
            this.builder = builder;
        }

        @Override
        public void processListenerMethod(Object pojo, Method method, String name) {
            this.listenerMap.computeIfAbsent(name, v -> new ArrayList()).add(method);
        }

        @Override
        public void processListenerField(Object pojo, Field field, String name) {
            this.listenerMap.computeIfAbsent(name, v -> new ArrayList()).add(field);
        }

        @Override
        public void processGroup(Object pojo, Field group) throws ProcessingMemberException {
            try {
                String name = this.findName(group);
                ConfigTreeBuilder sub = this.builder.fork(name);
                group.setAccessible(true);
                Object subPojo = group.get(pojo);
                if (subPojo == null) {
                    throw new ProcessingMemberException("Group " + name + " is null. Did you forget to initialize it?", group);
                }
                AnnotatedSettingsImpl.this.applyToNode(sub, subPojo);
                this.applyAnnotationProcessors(pojo, group, sub, AnnotatedSettingsImpl.this.groupSettingProcessors);
                sub.build();
            }
            catch (FiberException | IllegalAccessException e) {
                throw new ProcessingMemberException("Failed to process group '" + Modifier.toString(group.getModifiers()) + " " + group.getType().getSimpleName() + " " + group.getName() + "' in " + group.getDeclaringClass().getSimpleName(), e, group);
            }
        }

        @Override
        public void processSetting(Object pojo, Field setting) throws ProcessingMemberException {
            try {
                AnnotatedSettingsImpl.checkViolation(setting);
                this.processSetting(pojo, setting, this.toConfigType(setting.getAnnotatedType()));
            }
            catch (FiberException e) {
                throw new ProcessingMemberException("Failed to process setting '" + Modifier.toString(setting.getModifiers()) + " " + setting.getType().getSimpleName() + " " + setting.getName() + "' in " + setting.getDeclaringClass().getSimpleName(), e, setting);
            }
        }

        private <R, S> void processSetting(Object pojo, Field setting, ConfigType<R, S, ?> type) throws FiberException {
            String name = this.findName(setting);
            List<Member> listeners = this.listenerMap.getOrDefault(name, Collections.emptyList());
            ConfigLeafBuilder leaf = ((ConfigLeafBuilder)this.builder.beginValue(name, type, this.findDefaultValue(pojo, setting)).withComment(this.findComment(setting))).withListener(this.constructListener(pojo, setting, listeners, type));
            this.applyAnnotationProcessors(pojo, setting, leaf, AnnotatedSettingsImpl.this.valueSettingProcessors);
            leaf.build();
        }

        @Nonnull
        private String findName(Field field) {
            return AnnotatedSettingsImpl.findSettingAnnotation(Setting.Group.class, field).map(Setting.Group::name).filter(s -> !s.isEmpty()).orElseGet(() -> AnnotatedSettingsImpl.findSettingAnnotation(Setting.class, field).map(Setting::name).filter(s -> !s.isEmpty()).orElseGet(() -> this.convention.name(field.getName())));
        }

        @Nullable
        private String findComment(Field field) {
            return AnnotatedSettingsImpl.findSettingAnnotation(Setting.class, field).map(Setting::comment).filter(s -> !s.isEmpty()).orElse(null);
        }

        @Nonnull
        private <R> BiConsumer<R, R> constructListener(Object pojo, Field setting, List<Member> listeners, ConfigType<R, ?, ?> type) throws FiberException {
            BiConsumer<Object, Object> ret = (t, newValue) -> {
                try {
                    setting.setAccessible(true);
                    setting.set(pojo, newValue);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeFiberException("Failed to update field value", e);
                }
            };
            for (Member listener : listeners) {
                BiConsumer<R, R> consumer = this.constructListenerFromMember(pojo, listener, type.getRuntimeType());
                if (consumer == null) continue;
                ret = ret.andThen(consumer);
            }
            return ret;
        }

        private <C> void applyAnnotationProcessors(Object pojo, Field field, C sub, Map<Class<? extends Annotation>, ? extends ConfigAnnotationProcessor<?, Field, C>> settingProcessors) {
            for (Annotation annotation : field.getAnnotations()) {
                ConfigAnnotationProcessor<?, Field, C> processor = settingProcessors.get(annotation.annotationType());
                if (processor == null) continue;
                processor.apply(annotation, field, pojo, sub);
            }
        }

        @Nonnull
        private ConfigType<?, ?, ?> toConfigType(AnnotatedType annotatedType) throws FiberTypeProcessingException {
            ConfigType ret;
            Class<?> clazz = TypeMagic.classForType(annotatedType.getType());
            if (clazz == null) {
                throw new FiberTypeProcessingException("Unknown type " + annotatedType.getType().getTypeName());
            }
            if (annotatedType instanceof AnnotatedArrayType) {
                ConfigType<?, ?, ?> componentType = this.toConfigType(((AnnotatedArrayType)annotatedType).getAnnotatedGenericComponentType());
                Class<?> componentClass = clazz.getComponentType();
                assert (componentClass != null);
                ret = this.makeArrayConfigType(componentClass, componentType);
            } else if (AnnotatedSettingsImpl.this.registeredGenericTypes.containsKey(clazz)) {
                ParameterizedTypeProcessor parameterizedTypeProcessor = (ParameterizedTypeProcessor)AnnotatedSettingsImpl.this.registeredGenericTypes.get(clazz);
                if (!(annotatedType instanceof AnnotatedParameterizedType)) {
                    throw new FiberTypeProcessingException("Expected type parameters for " + clazz);
                }
                AnnotatedType[] annotatedTypeArgs = ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments();
                ConfigType[] typeArguments = new ConfigType[annotatedTypeArgs.length];
                for (int i = 0; i < annotatedTypeArgs.length; ++i) {
                    typeArguments[i] = this.toConfigType(annotatedTypeArgs[i]);
                }
                ret = parameterizedTypeProcessor.process(typeArguments);
            } else if (AnnotatedSettingsImpl.this.registeredTypes.containsKey(clazz)) {
                ret = (EnumConfigType<Enum>)AnnotatedSettingsImpl.this.registeredTypes.get(clazz);
            } else if (clazz.isEnum()) {
                ret = ConfigTypes.makeEnum(clazz.asSubclass(Enum.class));
            } else {
                Optional<Class> closestParent = Stream.concat(AnnotatedSettingsImpl.this.registeredGenericTypes.keySet().stream(), AnnotatedSettingsImpl.this.registeredTypes.keySet().stream()).filter(c -> c.isAssignableFrom(clazz)).reduce((c1, c2) -> c1.isAssignableFrom((Class<?>)c2) ? c2 : c1);
                String closestParentSuggestion = closestParent.map(p -> "declaring the element as '" + p.getTypeName() + "', or ").orElse("");
                throw new FiberTypeProcessingException("Unknown config type " + annotatedType.getType().getTypeName() + ". Consider marking as transient, or " + closestParentSuggestion + "registering a new Class -> ConfigType mapping.");
            }
            assert (ret != null);
            return this.constrain(ret, annotatedType);
        }

        private ConfigType<?, ?, ?> makeArrayConfigType(Class<?> componentClass, ConfigType<?, ?, ?> componentType) {
            assert (TypeMagic.wrapPrimitive(componentClass) == TypeMagic.wrapPrimitive(componentType.getRuntimeType())) : "Class=" + componentClass + ", ConfigType=" + componentType;
            if (componentClass == Boolean.TYPE) {
                return ConfigTypes.makeBooleanArray(componentType);
            }
            if (componentClass == Byte.TYPE) {
                return ConfigTypes.makeByteArray(componentType);
            }
            if (componentClass == Short.TYPE) {
                return ConfigTypes.makeShortArray(componentType);
            }
            if (componentClass == Integer.TYPE) {
                return ConfigTypes.makeIntArray(componentType);
            }
            if (componentClass == Long.TYPE) {
                return ConfigTypes.makeLongArray(componentType);
            }
            if (componentClass == Float.TYPE) {
                return ConfigTypes.makeFloatArray(componentType);
            }
            if (componentClass == Double.TYPE) {
                return ConfigTypes.makeDoubleArray(componentType);
            }
            if (componentClass == Character.TYPE) {
                return ConfigTypes.makeCharArray(componentType);
            }
            assert (!componentClass.isPrimitive()) : "Primitive component type: " + componentClass;
            return ConfigTypes.makeArray(componentType);
        }

        private <T extends ConfigType<?, ?, ?>> T constrain(T type, AnnotatedElement annotated) throws FiberTypeProcessingException {
            T ret = type;
            for (Annotation annotation : annotated.getAnnotations()) {
                ConstraintAnnotationProcessor processor = (ConstraintAnnotationProcessor)AnnotatedSettingsImpl.this.constraintProcessors.get(annotation.annotationType());
                if (processor == null) continue;
                try {
                    ret = this.constrain(ret, processor, annotation, annotated);
                }
                catch (UnsupportedOperationException e) {
                    throw new FiberTypeProcessingException("Failed to constrain type " + type, e);
                }
            }
            return ret;
        }

        private <T extends ConfigType<?, ?, ?>> T constrain(T type, ConstraintAnnotationProcessor<Annotation> processor, Annotation annotation, AnnotatedElement annotated) {
            return (T)type.constrain(processor, annotation, annotated);
        }

        private <T> T findDefaultValue(Object pojo, Field field) throws FiberException {
            Object value;
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                value = field.get(pojo);
                if (value == null) {
                    throw new MalformedFieldException("Default value for field '" + field.getName() + "' is null");
                }
            }
            catch (IllegalAccessException e) {
                throw new FiberException("Couldn't get value for field '" + field.getName() + "'", e);
            }
            field.setAccessible(accessible);
            return (T)value;
        }

        private <T> BiConsumer<T, T> constructListenerFromMember(Object pojo, Member listener, Class<T> wantedType) throws FiberException {
            BiConsumer<T, T> result;
            if (listener instanceof Field) {
                result = this.constructListenerFromField(pojo, (Field)listener, wantedType);
            } else if (listener instanceof Method) {
                result = this.constructListenerFromMethod(pojo, (Method)listener, wantedType);
            } else {
                throw new FiberException("Cannot create listener from " + listener + ": must be a field or method");
            }
            return result;
        }

        private <T, A> BiConsumer<T, T> constructListenerFromMethod(Object pojo, Method method, Class<A> wantedType) throws FiberException {
            int i = this.checkListenerMethod(method, wantedType);
            method.setAccessible(true);
            boolean staticMethod = Modifier.isStatic(method.getModifiers());
            switch (i) {
                case 1: {
                    return (oldValue, newValue) -> {
                        try {
                            method.invoke(staticMethod ? null : pojo, newValue);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeFiberException("Failed to invoke listener " + method + " with argument " + newValue, e);
                        }
                    };
                }
                case 2: {
                    return (oldValue, newValue) -> {
                        try {
                            method.invoke(staticMethod ? null : pojo, oldValue, newValue);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeFiberException("Failed to invoke listener " + method + " with arguments " + oldValue + ", " + newValue, e);
                        }
                    };
                }
            }
            throw new FiberException("Listener failed due to an invalid number of arguments.");
        }

        private <A> int checkListenerMethod(Method method, Class<A> wantedType) throws FiberException {
            if (!method.getReturnType().equals(Void.TYPE)) {
                throw new FiberException("Listener method must return void");
            }
            int paramCount = method.getParameterCount();
            if (paramCount != 1 && paramCount != 2 || !method.getParameterTypes()[0].equals(wantedType)) {
                throw new FiberException("Listener method must have exactly two parameters of type that it listens for");
            }
            return paramCount;
        }

        private <T, A> BiConsumer<T, T> constructListenerFromField(Object pojo, Field field, Class<A> wantedType) throws FiberException {
            this.checkListenerField(field, wantedType);
            field.setAccessible(true);
            try {
                BiConsumer consumer = (BiConsumer)field.get(pojo);
                return consumer;
            }
            catch (IllegalAccessException e) {
                throw new FiberException("Could not construct listener", e);
            }
        }

        private <A> void checkListenerField(Field field, Class<A> wantedType) throws MalformedFieldException {
            if (!field.getType().equals(BiConsumer.class)) {
                throw new MalformedFieldException("Field " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must be a BiConsumer");
            }
            ParameterizedType genericTypes = (ParameterizedType)field.getGenericType();
            if (genericTypes.getActualTypeArguments().length != 2) {
                throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have 2 generic types");
            }
            if (genericTypes.getActualTypeArguments()[0] != genericTypes.getActualTypeArguments()[1]) {
                throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have 2 identical generic types");
            }
            if (!genericTypes.getActualTypeArguments()[0].equals(wantedType)) {
                throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have the same generic type as the field it's listening for");
            }
        }
    }
}

