/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.schema;

import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import blue.endless.jankson.impl.Marshaller;
import java.util.HashMap;
import java.util.List;
import me.zeroeightsix.fiber.Identifier;
import me.zeroeightsix.fiber.builder.constraint.CompositeConstraintBuilder;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.constraint.ValuedConstraint;
import me.zeroeightsix.fiber.tree.ConfigValue;
import me.zeroeightsix.fiber.tree.Node;

public class Schemas {
    private static HashMap<Class, Identifier> classIdentifierHashMap = new HashMap();

    public static JsonObject createSchema(Node node) {
        JsonObject object = new JsonObject();
        node.getItems().forEach(item -> {
            if (item instanceof Node) {
                object.put(item.getName(), Schemas.createSchema((Node)item));
            } else if (item instanceof ConfigValue) {
                object.put(item.getName(), Schemas.createSchema((ConfigValue)item));
            }
        });
        return object;
    }

    private static JsonObject createSchema(ConfigValue item) {
        JsonObject object = new JsonObject();
        if (item.getType() != null && classIdentifierHashMap.containsKey(item.getType())) {
            object.put("type", new JsonPrimitive(classIdentifierHashMap.get(item.getType())));
        }
        if (item.getComment() != null) {
            object.put("comment", new JsonPrimitive(item.getComment()));
        }
        if (item.getDefaultValue() != null) {
            object.put("defaultValue", Marshaller.getFallback().serialize(item.getDefaultValue()));
        }
        if (!item.getConstraints().isEmpty()) {
            object.put("constraints", Schemas.createSchema(item.getConstraints()));
        }
        return object;
    }

    private static JsonElement createSchema(List<Constraint> constraintList) {
        JsonArray array = new JsonArray();
        for (Constraint constraint : constraintList) {
            JsonObject object = new JsonObject();
            object.put("identifier", new JsonPrimitive(constraint.getType().getIdentifier().toString()));
            if (constraint instanceof ValuedConstraint) {
                object.put("value", new JsonPrimitive(((ValuedConstraint)constraint).getValue()));
            }
            if (constraint instanceof CompositeConstraintBuilder.AbstractCompositeConstraint) {
                object.put("constraints", Schemas.createSchema(((CompositeConstraintBuilder.AbstractCompositeConstraint)constraint).constraints));
            }
            array.add(object);
        }
        return array;
    }

    private static Identifier identifier(String name) {
        return new Identifier("fabric", name);
    }

    static {
        classIdentifierHashMap.put(Boolean.class, Schemas.identifier("boolean"));
        classIdentifierHashMap.put(Byte.class, Schemas.identifier("byte"));
        classIdentifierHashMap.put(Short.class, Schemas.identifier("short"));
        classIdentifierHashMap.put(Integer.class, Schemas.identifier("int"));
        classIdentifierHashMap.put(Long.class, Schemas.identifier("long"));
        classIdentifierHashMap.put(Float.class, Schemas.identifier("float"));
        classIdentifierHashMap.put(Double.class, Schemas.identifier("double"));
        classIdentifierHashMap.put(String.class, Schemas.identifier("string"));
    }
}

