/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import me.zeroeightsix.fiber.NodeOperations;
import me.zeroeightsix.fiber.annotation.Comment;
import me.zeroeightsix.fiber.annotation.Constrain;
import me.zeroeightsix.fiber.annotation.Listener;
import me.zeroeightsix.fiber.annotation.Setting;
import me.zeroeightsix.fiber.annotation.Settings;
import me.zeroeightsix.fiber.annotation.convention.NoNamingConvention;
import me.zeroeightsix.fiber.annotation.convention.SettingNamingConvention;
import me.zeroeightsix.fiber.annotation.exception.MalformedConstructorException;
import me.zeroeightsix.fiber.annotation.exception.MalformedFieldException;
import me.zeroeightsix.fiber.builder.ConfigValueBuilder;
import me.zeroeightsix.fiber.builder.constraint.ConstraintsBuilder;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.tree.ConfigNode;
import me.zeroeightsix.fiber.tree.ConfigValue;
import me.zeroeightsix.fiber.tree.Node;

public class AnnotatedSettings {
    public static void applyToNode(ConfigNode mergeTo, Object pojo) throws FiberException {
        ConfigNode node = AnnotatedSettings.parsePojo(pojo);
        NodeOperations.mergeTo(node, (Node)mergeTo);
    }

    private static ConfigNode parsePojo(Object pojo) throws FiberException {
        ConfigNode node = new ConfigNode();
        boolean forceFinals = true;
        boolean onlyAnnotated = false;
        SettingNamingConvention namingConvention = new NoNamingConvention();
        Class<?> pojoClass = pojo.getClass();
        if (pojoClass.isAnnotationPresent(Settings.class)) {
            Settings settingsAnnotation = pojoClass.getAnnotation(Settings.class);
            if (settingsAnnotation.noForceFinals()) {
                forceFinals = false;
            }
            onlyAnnotated = settingsAnnotation.onlyAnnotated();
            try {
                namingConvention = AnnotatedSettings.createNamingConvention(settingsAnnotation.namingConvention());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new MalformedConstructorException("Naming convention must have an empty constructor");
            }
        }
        AnnotatedSettings.parsePojo(pojo, namingConvention, node, forceFinals, onlyAnnotated);
        return node;
    }

    private static List<ConfigValue<?>> parsePojo(Object pojo, SettingNamingConvention convention, ConfigNode node, boolean forceFinals, boolean onlyAnnotated) throws MalformedFieldException {
        HashMap builderMap = new HashMap();
        HashMap listenerMap = new HashMap();
        for (Field field : pojo.getClass().getDeclaredFields()) {
            FieldProperties properties = AnnotatedSettings.getProperties(field);
            if (properties.ignored || onlyAnnotated && !field.isAnnotationPresent(Setting.class)) continue;
            if (forceFinals && !properties.noForceFinal && !Modifier.isFinal(field.getModifiers())) {
                throw new MalformedFieldException("Field " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must be final");
            }
            if (field.isAnnotationPresent(Listener.class)) {
                AnnotatedSettings.parseListener(pojo, builderMap, listenerMap, field);
                continue;
            }
            AnnotatedSettings.parseSetting(pojo, convention, node, builderMap, listenerMap, field, properties);
        }
        return builderMap.values().stream().map(pair -> ((ConfigValueBuilder)pair.a).withParent(node).build()).collect(Collectors.toList());
    }

    private static <T> void parseSetting(Object pojo, SettingNamingConvention convention, ConfigNode node, Map<String, BuilderWithClass<?>> builderMap, Map<String, ListenerWithClass<?>> listenerMap, Field field, FieldProperties properties) throws MalformedFieldException {
        String name;
        String conventionName;
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            type = AnnotatedSettings.wrapPrimitive(type);
        }
        ConfigValueBuilder<?> builder = ConfigValue.builder(type).withComment(properties.comment);
        if (properties.finalValue) {
            builder.setFinal();
        }
        name = properties.name != null ? properties.name : ((conventionName = convention.name(name = field.getName())) == null || conventionName.isEmpty() ? name : conventionName);
        builder.withName(name);
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        try {
            Object value = field.get(pojo);
            builder.withDefaultValue(value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        field.setAccessible(isAccessible);
        if (listenerMap.containsKey(name)) {
            ListenerWithClass<?> consumerClassPair = listenerMap.get(name);
            if (!((Class)consumerClassPair.b).equals(type)) {
                throw new MalformedFieldException("Field " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " has a listener of type " + ((Class)consumerClassPair.b).getCanonicalName() + ", while it has to be of type " + type.getCanonicalName());
            }
            builder.withListener((BiConsumer)consumerClassPair.a);
        }
        AnnotatedSettings.parseConstraints(field, builder);
        builderMap.put(name, new BuilderWithClass(builder, type));
    }

    private static <T> void parseConstraints(Field field, ConfigValueBuilder<T> builder) {
        ConstraintsBuilder<Double> constraintsBuilder = builder.constraints();
        if (field.isAnnotationPresent(Constrain.Min.class)) {
            constraintsBuilder.minNumerical(field.getAnnotation(Constrain.Min.class).value());
        }
        if (field.isAnnotationPresent(Constrain.Max.class)) {
            constraintsBuilder.maxNumerical(field.getAnnotation(Constrain.Max.class).value());
        }
        constraintsBuilder.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void parseListener(Object pojo, Map<String, BuilderWithClass<?>> builderMap, Map<String, ListenerWithClass<?>> listenerMap, Field field) throws MalformedFieldException {
        BiConsumer consumer;
        if (!field.getType().equals(BiConsumer.class)) {
            throw new MalformedFieldException("Field " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must be a BiConsumer");
        }
        Listener annot = field.getAnnotation(Listener.class);
        String settingName = annot.value();
        ParameterizedType genericTypes = (ParameterizedType)field.getGenericType();
        if (genericTypes.getActualTypeArguments().length != 2) {
            throw new MalformedFieldException("Field " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have 2 generic types");
        }
        if (genericTypes.getActualTypeArguments()[0] != genericTypes.getActualTypeArguments()[1]) {
            throw new MalformedFieldException("Field " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have 2 identical generic types");
        }
        Class genericType = (Class)genericTypes.getActualTypeArguments()[0];
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        try {
            BiConsumer biConsumer = consumer = (BiConsumer)field.get(pojo);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        finally {
            field.setAccessible(isAccessible);
        }
        if (consumer == null) {
            return;
        }
        if (builderMap.containsKey(settingName)) {
            BuilderWithClass<?> builderClassPair = builderMap.get(settingName);
            ConfigValueBuilder builder = (ConfigValueBuilder)builderClassPair.a;
            Class clazz = (Class)builderClassPair.b;
            if (!clazz.equals(genericType)) {
                throw new MalformedFieldException("Field " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must be of type " + clazz.getCanonicalName());
            }
            builder.withListener(consumer);
        } else {
            listenerMap.put(settingName, new ListenerWithClass(consumer, genericType));
        }
    }

    private static String getComment(Comment annotation) {
        return annotation == null ? null : annotation.value();
    }

    private static String getComment(Field field) {
        return AnnotatedSettings.getComment(field.getAnnotation(Comment.class));
    }

    private static SettingNamingConvention createNamingConvention(Class<? extends SettingNamingConvention> namingConvention) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return namingConvention.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static <T> Class<T> wrapPrimitive(Class<T> type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        return null;
    }

    private static FieldProperties getProperties(Field field) {
        String customName;
        String comment = AnnotatedSettings.getComment(field);
        String string = customName = field.isAnnotationPresent(Setting.class) ? field.getAnnotation(Setting.class).name() : null;
        if (customName != null && customName.isEmpty()) {
            customName = null;
        }
        boolean ignored = field.isAnnotationPresent(Setting.Ignored.class);
        boolean noForceFinal = field.isAnnotationPresent(Setting.NoForceFinal.class);
        boolean finalValue = field.isAnnotationPresent(Setting.Final.class);
        HashSet<Constrain> constraints = new HashSet<Constrain>();
        return new FieldProperties(comment, customName, ignored, noForceFinal, finalValue, constraints);
    }

    private static class ListenerWithClass<T>
    extends Pair<BiConsumer<T, T>, Class<T>> {
        public ListenerWithClass(BiConsumer<T, T> a, Class<T> b) {
            super(a, b);
        }
    }

    private static class BuilderWithClass<T>
    extends Pair<ConfigValueBuilder<T>, Class<T>> {
        public BuilderWithClass(ConfigValueBuilder<T> a, Class<T> b) {
            super(a, b);
        }
    }

    private static class Pair<A, B> {
        A a;
        B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }

    private static class FieldProperties {
        final String comment;
        final String name;
        final boolean ignored;
        final boolean noForceFinal;
        final boolean finalValue;
        final Set<Constrain> constraintSet;

        FieldProperties(String comment, String name, boolean ignored, boolean noForceFinal, boolean finalValue, Set<Constrain> constraintSet) {
            this.comment = comment;
            this.name = name;
            this.ignored = ignored;
            this.noForceFinal = noForceFinal;
            this.finalValue = finalValue;
            this.constraintSet = constraintSet;
        }
    }
}

