/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder.constraint;

import java.util.List;
import me.zeroeightsix.fiber.builder.constraint.AbstractConstraintsBuilder;
import me.zeroeightsix.fiber.builder.constraint.ConstraintsBuilder;
import me.zeroeightsix.fiber.constraint.CompositeType;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.constraint.Constraints;
import me.zeroeightsix.fiber.constraint.ValuedConstraint;

public final class CompositeConstraintBuilder<T>
extends AbstractConstraintsBuilder<T> {
    private final ConstraintsBuilder<T> source;
    private final CompositeType compositeType;

    public CompositeConstraintBuilder(CompositeType compositeType, List<Constraint<? super T>> sourceConstraints, Class<T> type, ConstraintsBuilder<T> source) {
        super(sourceConstraints, type);
        this.source = source;
        this.compositeType = compositeType;
    }

    public CompositeConstraintBuilder<T> minNumerical(T min) {
        this.addNumericalLowerBound(min);
        return this;
    }

    public CompositeConstraintBuilder<T> maxNumerical(T min) {
        this.addNumericalUpperBound(min);
        return this;
    }

    public ConstraintsBuilder<T> finishComposite() {
        this.addConstraints();
        return this.source;
    }

    @Override
    void addConstraints() {
        switch (this.compositeType) {
            case OR: {
                this.sourceConstraints.add(new OrCompositeConstraint(this.newConstraints));
                break;
            }
            case AND: {
                this.sourceConstraints.add(new AndCompositeConstraint(this.newConstraints));
                break;
            }
            case INVERT: {
                this.sourceConstraints.add(new InvertCompositeConstraint(this.newConstraints));
            }
        }
    }

    private static class InvertCompositeConstraint<T>
    extends AbstractCompositeConstraint<T> {
        public InvertCompositeConstraint(List<Constraint<? super T>> constraints) {
            super(CompositeType.INVERT, constraints);
        }

        @Override
        public boolean test(T value) {
            return !this.constraints.stream().anyMatch(constraint -> constraint.test(value));
        }
    }

    private static class OrCompositeConstraint<T>
    extends AbstractCompositeConstraint<T> {
        public OrCompositeConstraint(List<Constraint<? super T>> constraints) {
            super(CompositeType.OR, constraints);
        }

        @Override
        public boolean test(T value) {
            return this.constraints.stream().anyMatch(constraint -> constraint.test(value));
        }
    }

    private static class AndCompositeConstraint<T>
    extends AbstractCompositeConstraint<T> {
        public AndCompositeConstraint(List<Constraint<? super T>> constraints) {
            super(CompositeType.AND, constraints);
        }

        @Override
        public boolean test(T value) {
            return this.constraints.stream().anyMatch(constraint -> constraint.test(value));
        }
    }

    public static abstract class AbstractCompositeConstraint<T>
    extends ValuedConstraint<String, T> {
        public final List<Constraint<? super T>> constraints;

        public AbstractCompositeConstraint(CompositeType type, List<Constraint<? super T>> constraints) {
            super(Constraints.COMPOSITE, type.getName());
            this.constraints = constraints;
        }
    }
}

