/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.impl.SyntaxError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.Marshaller;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.tree.HasValue;
import me.zeroeightsix.fiber.tree.Node;
import me.zeroeightsix.fiber.tree.Property;
import me.zeroeightsix.fiber.tree.Transparent;
import me.zeroeightsix.fiber.tree.TreeItem;

public class JanksonSettings {
    @Nullable
    private Marshaller<JsonElement> marshaller;

    public JanksonSettings(@Nullable Marshaller<JsonElement> marshaller) {
        this.marshaller = marshaller;
    }

    public JanksonSettings() {
        this(null);
    }

    public void deserialize(Node node, InputStream stream) throws IOException, FiberException {
        JsonObject object;
        Jankson jankson = Jankson.builder().build();
        try {
            object = jankson.load(stream);
        }
        catch (SyntaxError syntaxError) {
            throw new FiberException("Configuration file was malformed", syntaxError);
        }
        this.deserialize(node, object);
    }

    private void deserialize(Node node, JsonObject element) throws FiberException {
        JsonObject object = element;
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            String key = entry.getKey();
            JsonElement child = entry.getValue();
            TreeItem item = node.lookup(key);
            if (item != null) {
                if (item instanceof Property) {
                    this.setPopertyValue((Property)((Object)item), child);
                    continue;
                }
                if (item instanceof Node && child instanceof JsonObject) {
                    this.deserialize((Node)item, (JsonObject)child);
                    continue;
                }
                throw new FiberException("Value read for non-property node: " + item.getName());
            }
            JanksonTransparentNode transparentNode = new JanksonTransparentNode(key, child);
            node.add(transparentNode);
        }
    }

    private <T> void setPopertyValue(Property<T> property, JsonElement child) {
        Class type = property.getType();
        property.setValue(this.marshall(type, child));
    }

    public void serialize(Node node, OutputStream stream, boolean compress) throws IOException {
        JsonObject object = this.serialize(node);
        stream.write(object.toJson(!compress, !compress).getBytes());
    }

    private JsonObject serialize(Node node) {
        JsonObject object = new JsonObject();
        node.getItems().forEach(treeItem -> {
            if (treeItem instanceof Node) {
                Node subNode = (Node)treeItem;
                object.put(subNode.getName(), this.serialize(subNode));
                return;
            }
            if (treeItem instanceof HasValue) {
                object.put(treeItem.getName(), this.serialize((HasValue)((Object)treeItem)));
            }
        });
        return object;
    }

    private JsonElement serialize(HasValue<?> hasValue) {
        JsonElement element;
        JsonElement jsonElement = element = this.marshaller != null ? this.marshaller.marshall(hasValue.getValue()) : null;
        if (element != null) {
            return element;
        }
        return blue.endless.jankson.impl.Marshaller.getFallback().serialize(hasValue.getValue());
    }

    private <A> A marshall(Class<A> type, JsonElement value) {
        A object;
        A a = object = this.marshaller != null ? (A)this.marshaller.marshallReverse(type, value) : null;
        if (object != null) {
            return object;
        }
        return blue.endless.jankson.impl.Marshaller.getFallback().marshall(type, value);
    }

    private class JanksonTransparentNode
    implements Transparent {
        private final String name;
        private final JsonElement value;

        public JanksonTransparentNode(String name, JsonElement value) {
            this.name = name;
            this.value = value;
        }

        @Override
        @Nullable
        public <A> A marshall(Class<A> type) {
            return (A)JanksonSettings.this.marshall(type, this.value);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[name=" + this.getName() + "]";
        }
    }
}

