/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import me.zeroeightsix.fiber.NodeOperations;
import me.zeroeightsix.fiber.annotation.Listener;
import me.zeroeightsix.fiber.annotation.Setting;
import me.zeroeightsix.fiber.annotation.Settings;
import me.zeroeightsix.fiber.annotation.convention.NoNamingConvention;
import me.zeroeightsix.fiber.annotation.convention.SettingNamingConvention;
import me.zeroeightsix.fiber.annotation.exception.MalformedFieldException;
import me.zeroeightsix.fiber.builder.ConfigValueBuilder;
import me.zeroeightsix.fiber.builder.constraint.ConstraintsBuilder;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.tree.ConfigNode;
import me.zeroeightsix.fiber.tree.Node;
import me.zeroeightsix.fiber.tree.TreeItem;

public class AnnotatedSettings {
    public static <P> void applyToNode(Node mergeTo, P pojo) throws FiberException {
        SettingNamingConvention convention;
        boolean onlyAnnotated;
        boolean noForceFinals;
        Class<?> pojoClass = pojo.getClass();
        if (pojoClass.isAnnotationPresent(Settings.class)) {
            Settings settingsAnnotation = pojoClass.getAnnotation(Settings.class);
            noForceFinals = settingsAnnotation.noForceFinals();
            onlyAnnotated = settingsAnnotation.onlyAnnotated();
            convention = AnnotatedSettings.createConvention(settingsAnnotation.namingConvention());
        } else {
            onlyAnnotated = false;
            noForceFinals = false;
            convention = new NoNamingConvention();
        }
        NodeOperations.mergeTo(AnnotatedSettings.constructNode(pojoClass, pojo, noForceFinals, onlyAnnotated, convention), mergeTo);
    }

    private static <P> Node constructNode(Class<P> pojoClass, P pojo, boolean noForceFinals, boolean onlyAnnotated, SettingNamingConvention convention) throws FiberException {
        ConfigNode node = new ConfigNode();
        ArrayList defaultEmpty = new ArrayList();
        Map<String, List<Field>> listenerMap = AnnotatedSettings.findListeners(pojoClass);
        for (Field field : pojoClass.getDeclaredFields()) {
            if (field.isSynthetic() || !AnnotatedSettings.isIncluded(field, onlyAnnotated)) continue;
            AnnotatedSettings.checkViolation(field, noForceFinals);
            String name = AnnotatedSettings.findName(field, convention);
            if (field.isAnnotationPresent(Setting.Node.class)) {
                Node sub = node.fork(name);
                try {
                    AnnotatedSettings.applyToNode(sub, field.get(pojo));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new FiberException("Couldn't fork and apply sub-node", e);
                }
            }
            node.add(AnnotatedSettings.fieldToItem(field, pojo, name, listenerMap.getOrDefault(name, defaultEmpty)));
        }
        return node;
    }

    private static Map<String, List<Field>> findListeners(Class<?> pojoClass) {
        return Arrays.stream(pojoClass.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Listener.class)).collect(Collectors.groupingBy(field -> field.getAnnotation(Listener.class).value()));
    }

    private static boolean isIncluded(Field field, boolean onlyAnnotated) {
        if (AnnotatedSettings.isIgnored(field)) {
            return false;
        }
        return !onlyAnnotated || field.isAnnotationPresent(Setting.class);
    }

    private static boolean isIgnored(Field field) {
        return AnnotatedSettings.getSettingAnnotation(field).map(Setting::ignore).orElse(false) != false || Modifier.isTransient(field.getModifiers());
    }

    private static void checkViolation(Field field, boolean noForceFinals) throws FiberException {
        if (!(noForceFinals || Modifier.isFinal(field.getModifiers()) || AnnotatedSettings.getSettingAnnotation(field).map(Setting::noForceFinal).orElse(false).booleanValue())) {
            throw new FiberException("Field '" + field.getName() + "' must be final");
        }
    }

    private static Optional<Setting> getSettingAnnotation(Field field) {
        return field.isAnnotationPresent(Setting.class) ? Optional.of(field.getAnnotation(Setting.class)) : Optional.empty();
    }

    private static <T, P> TreeItem fieldToItem(Field field, P pojo, String name, List<Field> fields) throws FiberException {
        Class<T> type = AnnotatedSettings.getSettingTypeFromField(field);
        ConfigValueBuilder<T> builder = new ConfigValueBuilder<T>(type).withName(name).withComment(AnnotatedSettings.findComment(field)).withDefaultValue(AnnotatedSettings.findDefaultValue(field, pojo)).setFinal(AnnotatedSettings.getSettingAnnotation(field).map(Setting::constant).orElse(false));
        AnnotatedSettings.constrain(builder.constraints(), field);
        for (Field listener : fields) {
            BiConsumer<T, T> consumer = AnnotatedSettings.constructListener(listener, pojo, type);
            if (consumer == null) continue;
            builder.withListener(consumer);
        }
        return builder.build();
    }

    private static <T> void constrain(ConstraintsBuilder<T> constraints, Field field) {
        if (field.isAnnotationPresent(Setting.Constrain.Min.class)) {
            constraints.minNumerical(field.getAnnotation(Setting.Constrain.Min.class).value());
        }
        if (field.isAnnotationPresent(Setting.Constrain.Max.class)) {
            constraints.maxNumerical(field.getAnnotation(Setting.Constrain.Max.class).value());
        }
        constraints.finish();
    }

    private static <T, P> T findDefaultValue(Field field, P pojo) throws FiberException {
        Object value;
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            value = field.get(pojo);
        }
        catch (IllegalAccessException e) {
            throw new FiberException("Couldn't get value for field '" + field.getName() + "'", e);
        }
        field.setAccessible(accessible);
        return (T)value;
    }

    private static <T, P, A> BiConsumer<T, T> constructListener(Field field, P pojo, Class<A> wantedType) throws FiberException {
        BiConsumer consumer;
        AnnotatedSettings.checkListener(field, wantedType);
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        try {
            BiConsumer biConsumer = consumer = (BiConsumer)field.get(pojo);
        }
        catch (IllegalAccessException e) {
            throw new FiberException("Couldn't construct listener", e);
        }
        field.setAccessible(isAccessible);
        return consumer;
    }

    private static <A> void checkListener(Field field, Class<A> wantedType) throws MalformedFieldException {
        if (!field.getType().equals(BiConsumer.class)) {
            throw new MalformedFieldException("Field " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must be a BiConsumer");
        }
        ParameterizedType genericTypes = (ParameterizedType)field.getGenericType();
        if (genericTypes.getActualTypeArguments().length != 2) {
            throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have 2 generic types");
        }
        if (genericTypes.getActualTypeArguments()[0] != genericTypes.getActualTypeArguments()[1]) {
            throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have 2 identical generic types");
        }
        if (!genericTypes.getActualTypeArguments()[0].equals(wantedType)) {
            throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have the same generic type as the field it's listening for");
        }
    }

    private static <T> Class<T> getSettingTypeFromField(Field field) {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            return AnnotatedSettings.wrapPrimitive(type);
        }
        return type;
    }

    private static <T> Class<T> wrapPrimitive(Class<T> type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        return null;
    }

    private static String findComment(Field field) {
        return AnnotatedSettings.getSettingAnnotation(field).map(Setting::comment).filter(s -> !s.isEmpty()).orElse(null);
    }

    private static String findName(Field field, SettingNamingConvention convention) {
        return Optional.ofNullable(field.isAnnotationPresent(Setting.Node.class) ? field.getAnnotation(Setting.Node.class).name() : (String)AnnotatedSettings.getSettingAnnotation(field).map(Setting::name).orElse(null)).filter(s -> !s.isEmpty()).orElse(convention.name(field.getName()));
    }

    private static SettingNamingConvention createConvention(Class<? extends SettingNamingConvention> namingConvention) throws FiberException {
        try {
            return namingConvention.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FiberException("Could not initialise naming convention", e);
        }
    }
}

