/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.builder.constraint.ConstraintsBuilder;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.tree.ConfigValue;
import me.zeroeightsix.fiber.tree.Node;

public class ConfigValueBuilder<T> {
    @Nonnull
    private final Class<T> type;
    @Nullable
    private String name;
    @Nullable
    private String comment = null;
    @Nullable
    private T defaultValue = null;
    private boolean isFinal = false;
    private BiConsumer<T, T> consumer = (t, t2) -> {};
    private List<Constraint<? super T>> constraintList = new ArrayList<Constraint<? super T>>();
    private Node parentNode = null;

    public ConfigValueBuilder(@Nonnull Class<T> type) {
        this.type = type;
    }

    public ConfigValueBuilder<T> withName(String name) {
        this.name = name;
        return this;
    }

    public ConfigValueBuilder<T> withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public ConfigValueBuilder<T> withListener(BiConsumer<T, T> consumer) {
        BiConsumer prevConsumer = this.consumer;
        this.consumer = (t, t2) -> {
            prevConsumer.accept(t, t2);
            consumer.accept(t, t2);
        };
        return this;
    }

    public ConfigValueBuilder<T> withDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ConfigValueBuilder<T> setFinal() {
        this.isFinal = true;
        return this;
    }

    public ConfigValueBuilder<T> setFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    public ConfigValueBuilder<T> withParent(Node node) {
        this.parentNode = node;
        return this;
    }

    public ConstraintsBuilder<T> constraints() {
        return new ConstraintsBuilder<T>(this.constraintList, this.type, this);
    }

    public ConfigValue<T> build() {
        ConfigValue<? super T> built = new ConfigValue<T>(this.name, this.comment, this.defaultValue, this.defaultValue, this.consumer, this.constraintList, this.type, this.isFinal);
        if (this.parentNode != null) {
            try {
                this.parentNode.add(built);
            }
            catch (Exception e) {
                throw new RuntimeFiberException("Failed to register leaf to node", e);
            }
        }
        return built;
    }
}

