/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.constraint;

import me.zeroeightsix.fiber.constraint.Constraints;
import me.zeroeightsix.fiber.constraint.ValuedConstraint;

public class StringLengthConstraint
extends ValuedConstraint<Integer, CharSequence> {
    public StringLengthConstraint(Constraints type, Integer value) {
        super(type, value);
        if (type != Constraints.STRING_MINIMUM_LENGTH && type != Constraints.STRING_MAXIMUM_LENGTH) {
            throw new IllegalArgumentException((Object)((Object)type) + " is not a string length constraint");
        }
    }

    @Override
    public boolean test(CharSequence value) {
        switch (this.getType()) {
            case STRING_MINIMUM_LENGTH: {
                return value.length() >= (Integer)this.getValue();
            }
            case STRING_MAXIMUM_LENGTH: {
                return value.length() <= (Integer)this.getValue();
            }
        }
        throw new IllegalStateException("A StringLengthConstraint must be of type STRING_MINIMUM_LENGTH or STRING_MAXIMUM_LENGTH");
    }
}

