/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder.constraint;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.RegEx;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.constraint.Constraints;
import me.zeroeightsix.fiber.constraint.NumberConstraint;
import me.zeroeightsix.fiber.constraint.RegexConstraint;
import me.zeroeightsix.fiber.constraint.StringLengthConstraint;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;

public abstract class AbstractConstraintsBuilder<T, B extends AbstractConstraintsBuilder<T, B>> {
    final List<Constraint<? super T>> sourceConstraints;
    protected final Class<T> type;
    final List<Constraint<? super T>> newConstraints = new ArrayList<Constraint<? super T>>();

    AbstractConstraintsBuilder(List<Constraint<? super T>> sourceConstraints, Class<T> type) {
        this.sourceConstraints = sourceConstraints;
        this.type = type;
    }

    public B minNumerical(T min) throws RuntimeFiberException {
        this.checkNumerical();
        this.checkNumerical(min);
        this.newConstraints.add(new NumberConstraint<Number>(Constraints.NUMERICAL_LOWER_BOUND, (Number)min));
        return (B)this;
    }

    public B maxNumerical(T min) throws RuntimeFiberException {
        this.checkNumerical();
        this.checkNumerical(min);
        this.newConstraints.add(new NumberConstraint<Number>(Constraints.NUMERICAL_UPPER_BOUND, (Number)min));
        return (B)this;
    }

    public B minStringLength(int min) {
        this.checkCharSequence();
        this.newConstraints.add(new StringLengthConstraint(Constraints.STRING_MINIMUM_LENGTH, min));
        return (B)this;
    }

    public B maxStringLength(int min) {
        this.checkCharSequence();
        this.newConstraints.add(new StringLengthConstraint(Constraints.STRING_MAXIMUM_LENGTH, min));
        return (B)this;
    }

    public B regex(@RegEx String regexPattern) {
        this.checkCharSequence();
        this.newConstraints.add(new RegexConstraint(Pattern.compile(regexPattern)));
        return (B)this;
    }

    private void checkNumerical() {
        if (!Number.class.isAssignableFrom(this.type)) {
            throw new UnsupportedOperationException("Can't apply numerical constraint to non-numerical setting");
        }
    }

    private void checkNumerical(T value) {
        if (!Number.class.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("'" + value + "' is not a number");
        }
    }

    private void checkCharSequence() {
        if (!CharSequence.class.isAssignableFrom(this.type)) {
            throw new UnsupportedOperationException("Can only apply regex pattern constraint to character sequences");
        }
    }

    void addConstraints() {
        this.sourceConstraints.addAll(this.newConstraints);
    }
}

