/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.lookup.block;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiLookupMap;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiProviderMap;
import net.fabricmc.fabric.mixin.lookup.BlockEntityTypeAccessor;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class BlockApiLookupImpl<A, C>
implements BlockApiLookup<A, C> {
    private static final Logger LOGGER = LogManager.getLogger((String)"fabric-api-lookup-api-v1/block");
    private static final ApiLookupMap<BlockApiLookup<?, ?>> LOOKUPS = ApiLookupMap.create(BlockApiLookupImpl::new);
    private final Class<A> apiClass;
    private final Class<C> contextClass;
    private final ApiProviderMap<class_2248, BlockApiLookup.BlockApiProvider<A, C>> providerMap = ApiProviderMap.create();
    private final List<BlockApiLookup.BlockApiProvider<A, C>> fallbackProviders = new CopyOnWriteArrayList<BlockApiLookup.BlockApiProvider<A, C>>();

    public static <A, C> BlockApiLookup<A, C> get(class_2960 lookupId, Class<A> apiClass, Class<C> contextClass) {
        return LOOKUPS.getLookup(lookupId, apiClass, contextClass);
    }

    private BlockApiLookupImpl(Class<?> apiClass, Class<?> contextClass) {
        this.apiClass = apiClass;
        this.contextClass = contextClass;
    }

    @Override
    @Nullable
    public A find(class_1937 world, class_2338 pos, @Nullable class_2680 state, @Nullable class_2586 blockEntity, C context) {
        Objects.requireNonNull(world, "World may not be null.");
        Objects.requireNonNull(pos, "BlockPos may not be null.");
        if (blockEntity == null) {
            if (state == null) {
                state = world.method_8320(pos);
            }
            if (state.method_31709()) {
                blockEntity = world.method_8321(pos);
            }
        } else if (state == null) {
            state = blockEntity.method_11010();
        }
        @Nullable BlockApiLookup.BlockApiProvider<A, C> provider = this.getProvider(state.method_26204());
        A instance = null;
        if (provider != null) {
            instance = provider.find(world, pos, state, blockEntity, context);
        }
        if (instance != null) {
            return instance;
        }
        for (BlockApiLookup.BlockApiProvider<A, C> fallbackProvider : this.fallbackProviders) {
            instance = fallbackProvider.find(world, pos, state, blockEntity, context);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    @Override
    public void registerSelf(class_2591<?> ... blockEntityTypes) {
        for (class_2591<?> blockEntityType : blockEntityTypes) {
            class_2248 supportBlock = ((BlockEntityTypeAccessor)blockEntityType).getBlocks().iterator().next();
            Objects.requireNonNull(supportBlock, "Could not get a support block for block entity type.");
            class_2586 blockEntity2 = blockEntityType.method_11032(class_2338.field_10980, supportBlock.method_9564());
            Objects.requireNonNull(blockEntity2, "Instantiated block entity may not be null.");
            if (this.apiClass.isAssignableFrom(blockEntity2.getClass())) continue;
            String errorMessage = String.format("Failed to register self-implementing block entities. API class %s is not assignable from block entity class %s.", this.apiClass.getCanonicalName(), blockEntity2.getClass().getCanonicalName());
            throw new IllegalArgumentException(errorMessage);
        }
        this.registerForBlockEntities((blockEntity, context) -> blockEntity, blockEntityTypes);
    }

    @Override
    public void registerForBlocks(BlockApiLookup.BlockApiProvider<A, C> provider, class_2248 ... blocks) {
        Objects.requireNonNull(provider, "BlockApiProvider may not be null.");
        if (blocks.length == 0) {
            throw new IllegalArgumentException("Must register at least one Block instance with a BlockApiProvider.");
        }
        for (class_2248 block : blocks) {
            Objects.requireNonNull(block, "Encountered null block while registering a block API provider mapping.");
            if (this.providerMap.putIfAbsent(block, provider) == null) continue;
            LOGGER.warn("Encountered duplicate API provider registration for block: " + class_2378.field_11146.method_10221((Object)block));
        }
    }

    @Override
    public void registerForBlockEntities(BlockApiLookup.BlockEntityApiProvider<A, C> provider, class_2591<?> ... blockEntityTypes) {
        Objects.requireNonNull(provider, "BlockEntityApiProvider may not be null.");
        if (blockEntityTypes.length == 0) {
            throw new IllegalArgumentException("Must register at least one BlockEntityType instance with a BlockEntityApiProvider.");
        }
        BlockApiLookup.BlockApiProvider<Object, Object> nullCheckedProvider = (world, pos, state, blockEntity, context) -> {
            if (blockEntity == null) {
                return null;
            }
            return provider.find(blockEntity, context);
        };
        for (class_2591<?> blockEntityType : blockEntityTypes) {
            Objects.requireNonNull(blockEntityType, "Encountered null block entity type while registering a block entity API provider mapping.");
            class_2248[] blocks = ((BlockEntityTypeAccessor)blockEntityType).getBlocks().toArray(new class_2248[0]);
            this.registerForBlocks(nullCheckedProvider, blocks);
        }
    }

    @Override
    public void registerFallback(BlockApiLookup.BlockApiProvider<A, C> fallbackProvider) {
        Objects.requireNonNull(fallbackProvider, "BlockApiProvider may not be null.");
        this.fallbackProviders.add(fallbackProvider);
    }

    @Override
    public Class<A> apiClass() {
        return this.apiClass;
    }

    @Override
    public Class<C> contextClass() {
        return this.contextClass;
    }

    @Nullable
    public BlockApiLookup.BlockApiProvider<A, C> getProvider(class_2248 block) {
        return this.providerMap.get(block);
    }

    public List<BlockApiLookup.BlockApiProvider<A, C>> getFallbackProviders() {
        return this.fallbackProviders;
    }
}

