/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.lookup.item;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiLookupMap;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiProviderMap;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ItemApiLookupImpl<A, C>
implements ItemApiLookup<A, C> {
    private static final Logger LOGGER = LogManager.getLogger((String)"fabric-api-lookup-api-v1/item");
    private static final ApiLookupMap<ItemApiLookup<?, ?>> LOOKUPS = ApiLookupMap.create(ItemApiLookupImpl::new);
    private final Class<A> apiClass;
    private final Class<C> contextClass;
    private final ApiProviderMap<class_1792, ItemApiLookup.ItemApiProvider<A, C>> providerMap = ApiProviderMap.create();
    private final List<ItemApiLookup.ItemApiProvider<A, C>> fallbackProviders = new CopyOnWriteArrayList<ItemApiLookup.ItemApiProvider<A, C>>();

    public static <A, C> ItemApiLookup<A, C> get(class_2960 lookupId, Class<A> apiClass, Class<C> contextClass) {
        return LOOKUPS.getLookup(lookupId, apiClass, contextClass);
    }

    private ItemApiLookupImpl(Class<?> apiClass, Class<?> contextClass) {
        this.apiClass = apiClass;
        this.contextClass = contextClass;
    }

    @Override
    @Nullable
    public A find(class_1799 itemStack, C context) {
        A instance;
        Objects.requireNonNull(itemStack, "ItemStack may not be null.");
        @Nullable ItemApiLookup.ItemApiProvider<A, C> provider = this.providerMap.get(itemStack.method_7909());
        if (provider != null && (instance = provider.find(itemStack, context)) != null) {
            return instance;
        }
        for (ItemApiLookup.ItemApiProvider<A, C> fallbackProvider : this.fallbackProviders) {
            A instance2 = fallbackProvider.find(itemStack, context);
            if (instance2 == null) continue;
            return instance2;
        }
        return null;
    }

    @Override
    public void registerSelf(class_1935 ... items) {
        for (class_1935 itemConvertible : items) {
            class_1792 item = itemConvertible.method_8389();
            if (this.apiClass.isAssignableFrom(item.getClass())) continue;
            String errorMessage = String.format("Failed to register self-implementing items. API class %s is not assignable from item class %s.", this.apiClass.getCanonicalName(), item.getClass().getCanonicalName());
            throw new IllegalArgumentException(errorMessage);
        }
        this.registerForItems((itemStack, context) -> itemStack.method_7909(), items);
    }

    @Override
    public void registerForItems(ItemApiLookup.ItemApiProvider<A, C> provider, class_1935 ... items) {
        Objects.requireNonNull(provider, "ItemApiProvider may not be null.");
        if (items.length == 0) {
            throw new IllegalArgumentException("Must register at least one ItemConvertible instance with an ItemApiProvider.");
        }
        for (class_1935 itemConvertible : items) {
            class_1792 item = itemConvertible.method_8389();
            Objects.requireNonNull(item, "Item convertible in item form may not be null.");
            if (this.providerMap.putIfAbsent(item, provider) == null) continue;
            LOGGER.warn("Encountered duplicate API provider registration for item: " + class_2378.field_11142.method_10221((Object)item));
        }
    }

    @Override
    public void registerFallback(ItemApiLookup.ItemApiProvider<A, C> fallbackProvider) {
        Objects.requireNonNull(fallbackProvider, "ItemApiProvider may not be null.");
        this.fallbackProviders.add(fallbackProvider);
    }

    @Override
    public Class<A> apiClass() {
        return this.apiClass;
    }

    @Override
    public Class<C> contextClass() {
        return this.contextClass;
    }
}

