/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome;

import java.net.Proxy;

import com.mojang.datafixers.DataFixer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.minecraft.class_2378;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_3950;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6904;
import net.minecraft.class_7497;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.fabricmc.fabric.impl.biome.NetherBiomeData;

// Priority set just below biome modification mixin's
@Mixin(value = MinecraftServer.class, priority = 990)
public class MinecraftServerMixin {
	@Shadow
	private class_5455.class_6890 getRegistryManager() {
		throw new AssertionError();
	}

	@Inject(method = "<init>", at = @At("RETURN"))
	private void addNetherBiomes(Thread serverThread, class_32.class_5143 session, class_3283 dataPackManager, class_6904 saveLoader, Proxy proxy, DataFixer dataFixer, class_7497 apiServices, class_3950 worldGenerationProgressListenerFactory, CallbackInfo ci) {
		class_2378<class_5363> registry = getRegistryManager().method_30530(class_7924.field_41224);

		registry.method_10220().forEach(dimensionOptions -> NetherBiomeData.modifyBiomeSource(getRegistryManager().method_46762(class_7924.field_41236), dimensionOptions.comp_1013().method_12098()));
	}
}
