/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.fabricmc.fabric.impl.biome.MultiNoiseSamplerHooks;
import net.fabricmc.fabric.impl.biome.WeightedPicker;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_3756;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import org.jetbrains.annotations.Nullable;

public final class TheEndBiomeData {
    public static final ThreadLocal<class_7871<class_1959>> biomeRegistry = new ThreadLocal();
    public static final Set<class_5321<class_1959>> ADDED_BIOMES = new HashSet<class_5321<class_1959>>();
    private static final Map<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>> END_BIOMES_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>>();
    private static final Map<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>> END_MIDLANDS_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>>();
    private static final Map<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>> END_BARRENS_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>>();

    private TheEndBiomeData() {
    }

    public static void addEndBiomeReplacement(class_5321<class_1959> replaced, class_5321<class_1959> variant, double weight) {
        Preconditions.checkNotNull(replaced, (Object)"replaced entry is null");
        Preconditions.checkNotNull(variant, (Object)"variant entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BIOMES_MAP.computeIfAbsent(replaced, key -> new WeightedPicker()).add(variant, weight);
        ADDED_BIOMES.add(variant);
    }

    public static void addEndMidlandsReplacement(class_5321<class_1959> highlands, class_5321<class_1959> midlands, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands entry is null");
        Preconditions.checkNotNull(midlands, (Object)"midlands entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_MIDLANDS_MAP.computeIfAbsent(highlands, key -> new WeightedPicker()).add(midlands, weight);
        ADDED_BIOMES.add(midlands);
    }

    public static void addEndBarrensReplacement(class_5321<class_1959> highlands, class_5321<class_1959> barrens, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands entry is null");
        Preconditions.checkNotNull(barrens, (Object)"midlands entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BARRENS_MAP.computeIfAbsent(highlands, key -> new WeightedPicker()).add(barrens, weight);
        ADDED_BIOMES.add(barrens);
    }

    public static Overrides createOverrides(class_7871<class_1959> biomes) {
        return new Overrides(biomes);
    }

    static {
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9411, key -> new WeightedPicker()).add(class_1972.field_9411, 1.0);
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedPicker()).add(class_1972.field_9442, 1.0);
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9457, key -> new WeightedPicker()).add(class_1972.field_9457, 1.0);
        END_MIDLANDS_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedPicker()).add(class_1972.field_9447, 1.0);
        END_BARRENS_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedPicker()).add(class_1972.field_9465, 1.0);
    }

    public static class Overrides {
        public final Set<class_6880<class_1959>> customBiomes;
        private final class_6880<class_1959> endMidlands;
        private final class_6880<class_1959> endBarrens;
        private final class_6880<class_1959> endHighlands;
        @Nullable
        private final Map<class_6880<class_1959>, WeightedPicker<class_6880<class_1959>>> endBiomesMap;
        @Nullable
        private final Map<class_6880<class_1959>, WeightedPicker<class_6880<class_1959>>> endMidlandsMap;
        @Nullable
        private final Map<class_6880<class_1959>, WeightedPicker<class_6880<class_1959>>> endBarrensMap;
        private final Map<class_6544.class_6552, class_3756> samplers = new WeakHashMap<class_6544.class_6552, class_3756>();

        public Overrides(class_7871<class_1959> biomeRegistry) {
            this.customBiomes = ADDED_BIOMES.stream().map(arg_0 -> biomeRegistry.method_46747(arg_0)).collect(Collectors.toSet());
            this.endMidlands = biomeRegistry.method_46747(class_1972.field_9447);
            this.endBarrens = biomeRegistry.method_46747(class_1972.field_9465);
            this.endHighlands = biomeRegistry.method_46747(class_1972.field_9442);
            this.endBiomesMap = this.resolveOverrides(biomeRegistry, END_BIOMES_MAP, (class_5321<class_1959>)class_1972.field_9411);
            this.endMidlandsMap = this.resolveOverrides(biomeRegistry, END_MIDLANDS_MAP, (class_5321<class_1959>)class_1972.field_9447);
            this.endBarrensMap = this.resolveOverrides(biomeRegistry, END_BARRENS_MAP, (class_5321<class_1959>)class_1972.field_9465);
        }

        @Nullable
        private Map<class_6880<class_1959>, WeightedPicker<class_6880<class_1959>>> resolveOverrides(class_7871<class_1959> biomeRegistry, Map<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>> overrides, class_5321<class_1959> vanillaKey) {
            Object2ObjectOpenCustomHashMap result = new Object2ObjectOpenCustomHashMap(overrides.size(), (Hash.Strategy)RegistryKeyHashStrategy.INSTANCE);
            for (Map.Entry<class_5321<class_1959>, WeightedPicker<class_5321<class_1959>>> entry : overrides.entrySet()) {
                WeightedPicker<class_5321<class_1959>> picker = entry.getValue();
                int count = picker.getEntryCount();
                if (count == 0 || count == 1 && entry.getKey() == vanillaKey) continue;
                result.put(biomeRegistry.method_46747(entry.getKey()), picker.map(arg_0 -> biomeRegistry.method_46747(arg_0)));
            }
            return result.isEmpty() ? null : result;
        }

        public class_6880<class_1959> pick(int x, int y, int z, class_6544.class_6552 noise, class_6880<class_1959> vanillaBiome) {
            block5: {
                boolean isMidlands;
                block4: {
                    isMidlands = vanillaBiome.method_40224(arg_0 -> this.endMidlands.method_40225(arg_0));
                    if (isMidlands) break block4;
                    if (!vanillaBiome.method_40224(arg_0 -> this.endBarrens.method_40225(arg_0))) break block5;
                }
                class_6880<class_1959> highlandsReplacement = this.pick(this.endHighlands, this.endHighlands, this.endBiomesMap, x, z, noise);
                Map<class_6880<class_1959>, WeightedPicker<class_6880<class_1959>>> map = isMidlands ? this.endMidlandsMap : this.endBarrensMap;
                return this.pick(highlandsReplacement, vanillaBiome, map, x, z, noise);
            }
            assert (END_BIOMES_MAP.containsKey(vanillaBiome.method_40230().orElseThrow()));
            return this.pick(vanillaBiome, vanillaBiome, this.endBiomesMap, x, z, noise);
        }

        private <T extends class_6880<class_1959>> T pick(T key, T defaultValue, Map<T, WeightedPicker<T>> pickers, int x, int z, class_6544.class_6552 noise) {
            WeightedPicker<T> picker;
            block6: {
                block5: {
                    if (pickers == null) {
                        return defaultValue;
                    }
                    picker = pickers.get(key);
                    if (picker == null) {
                        return defaultValue;
                    }
                    int count = picker.getEntryCount();
                    if (count == 0) break block5;
                    if (count != 1) break block6;
                    if (!key.method_40224(arg_0 -> this.endHighlands.method_40225(arg_0))) break block6;
                }
                return defaultValue;
            }
            return (T)((class_6880)picker.pickFromNoise(((MultiNoiseSamplerHooks)noise).fabric_getEndBiomesSampler(), (double)x / 64.0, 0.0, (double)z / 64.0));
        }
    }

    static enum RegistryKeyHashStrategy implements Hash.Strategy<class_6880<?>>
    {
        INSTANCE;


        public boolean equals(class_6880<?> a, class_6880<?> b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.method_40231() != b.method_40231()) {
                return false;
            }
            return (Boolean)a.method_40229().map(key -> b.method_40230().get() == key, b.comp_349()::equals);
        }

        public int hashCode(class_6880<?> a) {
            if (a == null) {
                return 0;
            }
            return (Integer)a.method_40229().map(System::identityHashCode, Object::hashCode);
        }
    }
}

