/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.biome.v1;

import net.fabricmc.fabric.impl.biome.NetherBiomeData;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6544;

/**
 * API that exposes the internals of Minecraft's nether biome code.
 *
 * <p><b>Experimental feature</b>, may be removed or changed without further notice.
 */
public final class NetherBiomes {
	private NetherBiomes() {
	}

	/**
	 * Adds a biome to the Nether generator.
	 *
	 * @param biome           The biome to add. Must not be null.
	 * @param mixedNoisePoint data about the given {@link class_1959}'s spawning information in the nether.
	 * @see class_6544.class_6553
	 */
	public static void addNetherBiome(class_5321<class_1959> biome, class_6544.class_6553 mixedNoisePoint) {
		NetherBiomeData.addNetherBiome(biome, class_6544.method_38117(
				mixedNoisePoint.comp_112(),
				mixedNoisePoint.comp_113(),
				mixedNoisePoint.comp_114(),
				mixedNoisePoint.comp_115(),
				mixedNoisePoint.comp_116(),
				mixedNoisePoint.comp_117(),
				0
		));
	}

	/**
	 * Adds a biome to the Nether generator.
	 *
	 * @param biome           The biome to add. Must not be null.
	 * @param mixedNoisePoint data about the given {@link class_1959}'s spawning information in the nether.
	 * @see class_6544.class_4762
	 */
	public static void addNetherBiome(class_5321<class_1959> biome, class_6544.class_4762 mixedNoisePoint) {
		NetherBiomeData.addNetherBiome(biome, mixedNoisePoint);
	}

	/**
	 * Returns true if the given biome can generate in the nether, considering the Vanilla nether biomes,
	 * and any biomes added to the Nether by mods.
	 */
	public static boolean canGenerateInNether(class_5321<class_1959> biome) {
		return NetherBiomeData.canGenerateInNether(biome);
	}
}
