/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.biome.modification;

import java.util.Optional;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BiomeSelectionContextImpl implements BiomeSelectionContext {
	private final class_5455 dynamicRegistries;
	private final class_5321<class_1959> key;
	private final class_1959 biome;
	private final class_6880<class_1959> entry;

	public BiomeSelectionContextImpl(class_5455 dynamicRegistries, class_5321<class_1959> key, class_1959 biome) {
		this.dynamicRegistries = dynamicRegistries;
		this.key = key;
		this.biome = biome;
		this.entry = dynamicRegistries.method_30530(class_7924.field_41236).method_46747(this.key);
	}

	@Override
	public class_5321<class_1959> getBiomeKey() {
		return key;
	}

	@Override
	public class_1959 getBiome() {
		return biome;
	}

	@Override
	public class_6880<class_1959> getBiomeRegistryEntry() {
		return entry;
	}

	@Override
	public Optional<class_5321<class_2975<?, ?>>> getFeatureKey(class_2975<?, ?> configuredFeature) {
		class_2378<class_2975<?, ?>> registry = dynamicRegistries.method_30530(class_7924.field_41239);
		return registry.method_29113(configuredFeature);
	}

	@Override
	public Optional<class_5321<class_6796>> getPlacedFeatureKey(class_6796 placedFeature) {
		class_2378<class_6796> registry = dynamicRegistries.method_30530(class_7924.field_41245);
		return registry.method_29113(placedFeature);
	}

	@Override
	public boolean validForStructure(class_5321<class_3195> key) {
		class_3195 instance = dynamicRegistries.method_30530(class_7924.field_41246).method_29107(key);

		if (instance == null) {
			return false;
		}

		return instance.method_41607().method_40241(getBiomeRegistryEntry());
	}

	@Override
	public Optional<class_5321<class_3195>> getStructureKey(class_3195 structure) {
		class_2378<class_3195> registry = dynamicRegistries.method_30530(class_7924.field_41246);
		return registry.method_29113(structure);
	}

	@Override
	public boolean canGenerateIn(class_5321<class_5363> dimensionKey) {
		class_5363 dimension = dynamicRegistries.method_30530(class_7924.field_41224).method_29107(dimensionKey);

		if (dimension == null) {
			return false;
		}

		return dimension.comp_1013().method_12098().method_28443().stream().anyMatch(entry -> entry.comp_349() == biome);
	}

	@Override
	public boolean hasTag(class_6862<class_1959> tag) {
		class_2378<class_1959> biomeRegistry = dynamicRegistries.method_30530(class_7924.field_41236);
		return biomeRegistry.method_46747(getBiomeKey()).method_40220(tag);
	}
}
