/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome.modification;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.minecraft.class_12197;
import net.minecraft.class_12199;
import net.minecraft.class_12206;
import net.minecraft.class_12212;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_3031;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6010;
import net.minecraft.class_6012;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.jetbrains.annotations.UnmodifiableView;
import org.jspecify.annotations.Nullable;

public class BiomeModificationContextImpl
implements BiomeModificationContext {
    private final class_5455 registries;
    private final class_1959 biome;
    private final BiomeModificationContext.WeatherContext weather;
    private final BiomeModificationContext.AttributesContext attributes;
    private final BiomeModificationContext.EffectsContext effects;
    private final GenerationSettingsContextImpl generationSettings;
    private final SpawnSettingsContextImpl spawnSettings;

    public BiomeModificationContextImpl(class_5455 registries, class_1959 biome) {
        this.registries = registries;
        this.biome = biome;
        this.weather = new WeatherContextImpl();
        this.attributes = new AttributesContextImpl();
        this.effects = new EffectsContextImpl();
        this.generationSettings = new GenerationSettingsContextImpl();
        this.spawnSettings = new SpawnSettingsContextImpl();
    }

    @Override
    public BiomeModificationContext.WeatherContext getWeather() {
        return this.weather;
    }

    @Override
    public BiomeModificationContext.AttributesContext getAttributes() {
        return this.attributes;
    }

    @Override
    public BiomeModificationContext.EffectsContext getEffects() {
        return this.effects;
    }

    @Override
    public BiomeModificationContext.GenerationSettingsContext getGenerationSettings() {
        return this.generationSettings;
    }

    @Override
    public BiomeModificationContext.SpawnSettingsContext getSpawnSettings() {
        return this.spawnSettings;
    }

    void freeze() {
        this.generationSettings.freeze();
        this.spawnSettings.freeze();
    }

    boolean shouldRebuildFeatures() {
        return this.generationSettings.rebuildFeatures;
    }

    private static <T> class_6880.class_6883<T> getEntry(class_2378<T> registry, class_5321<T> key) {
        class_6880.class_6883 entry = registry.method_46746(key).orElse(null);
        if (entry == null) {
            throw new IllegalArgumentException("Couldn't find registry entry for " + String.valueOf(key));
        }
        return entry;
    }

    private class WeatherContextImpl
    implements BiomeModificationContext.WeatherContext {
        private WeatherContextImpl() {
        }

        @Override
        public void setPrecipitation(boolean hasPrecipitation) {
            BiomeModificationContextImpl.this.biome.field_26393 = new class_1959.class_5482(hasPrecipitation, BiomeModificationContextImpl.this.biome.field_26393.comp_844(), BiomeModificationContextImpl.this.biome.field_26393.comp_845(), BiomeModificationContextImpl.this.biome.field_26393.comp_846());
        }

        @Override
        public void setTemperature(float temperature) {
            BiomeModificationContextImpl.this.biome.field_26393 = new class_1959.class_5482(BiomeModificationContextImpl.this.biome.field_26393.comp_1187(), temperature, BiomeModificationContextImpl.this.biome.field_26393.comp_845(), BiomeModificationContextImpl.this.biome.field_26393.comp_846());
        }

        @Override
        public void setTemperatureModifier(class_1959.class_5484 temperatureModifier) {
            BiomeModificationContextImpl.this.biome.field_26393 = new class_1959.class_5482(BiomeModificationContextImpl.this.biome.field_26393.comp_1187(), BiomeModificationContextImpl.this.biome.field_26393.comp_844(), Objects.requireNonNull(temperatureModifier), BiomeModificationContextImpl.this.biome.field_26393.comp_846());
        }

        @Override
        public void setDownfall(float downfall) {
            BiomeModificationContextImpl.this.biome.field_26393 = new class_1959.class_5482(BiomeModificationContextImpl.this.biome.field_26393.comp_1187(), BiomeModificationContextImpl.this.biome.field_26393.comp_844(), BiomeModificationContextImpl.this.biome.field_26393.comp_845(), downfall);
        }
    }

    private class AttributesContextImpl
    implements BiomeModificationContext.AttributesContext {
        private AttributesContextImpl() {
        }

        @Override
        public void addAll(class_12199 map) {
            class_12199.class_12200 attributes = class_12199.method_75661().method_75675(BiomeModificationContextImpl.this.biome.method_75734());
            attributes.method_75675(map);
            BiomeModificationContextImpl.this.biome.field_63809 = attributes.method_75672();
        }

        @Override
        public <T> void set(class_12197<T> key, T value) {
            class_12199.class_12200 attributes = class_12199.method_75661().method_75675(BiomeModificationContextImpl.this.biome.method_75734());
            attributes.method_75674(key, value);
            BiomeModificationContextImpl.this.biome.field_63809 = attributes.method_75672();
        }

        @Override
        public <T, M> void setModifier(class_12197<T> key, class_12212<T, M> modifier, M value) {
            class_12199.class_12200 attributes = class_12199.method_75661().method_75675(BiomeModificationContextImpl.this.biome.method_75734());
            attributes.method_75673(key, modifier, value);
            BiomeModificationContextImpl.this.biome.field_63809 = attributes.method_75672();
        }
    }

    private class EffectsContextImpl
    implements BiomeModificationContext.EffectsContext {
        private final class_4763 effects;

        private EffectsContextImpl() {
            this.effects = BiomeModificationContextImpl.this.biome.method_24377();
        }

        @Override
        public void setFogColor(int color) {
            BiomeModificationContextImpl.this.attributes.set(class_12206.field_63742, color);
        }

        @Override
        public void setWaterColor(int color) {
            this.effects.comp_5169 = color;
        }

        @Override
        public void setWaterFogColor(int color) {
            BiomeModificationContextImpl.this.attributes.set(class_12206.field_63744, color);
        }

        @Override
        public void setSkyColor(int color) {
            BiomeModificationContextImpl.this.attributes.set(class_12206.field_63746, color);
        }

        @Override
        public void setFoliageColor(Optional<Integer> color) {
            this.effects.comp_5170 = Objects.requireNonNull(color);
        }

        @Override
        public void setGrassColor(Optional<Integer> color) {
            this.effects.comp_5172 = Objects.requireNonNull(color);
        }

        @Override
        public void setGrassColorModifier(class_4763.class_5486 colorModifier) {
            this.effects.comp_5173 = Objects.requireNonNull(colorModifier);
        }

        @Override
        public void setMusicVolume(float volume) {
            BiomeModificationContextImpl.this.attributes.set(class_12206.field_63752, Float.valueOf(volume));
        }
    }

    private class GenerationSettingsContextImpl
    implements BiomeModificationContext.GenerationSettingsContext {
        private final class_2378<class_2922<?>> carvers;
        private final class_2378<class_6796> features;
        private final class_5485 generationSettings;
        boolean rebuildFeatures;

        GenerationSettingsContextImpl() {
            this.carvers = BiomeModificationContextImpl.this.registries.method_30530(class_7924.field_41238);
            this.features = BiomeModificationContextImpl.this.registries.method_30530(class_7924.field_41245);
            this.generationSettings = BiomeModificationContextImpl.this.biome.method_30970();
            this.unfreezeFeatures();
            this.rebuildFeatures = false;
        }

        private void unfreezeFeatures() {
            this.generationSettings.field_26416 = new ArrayList(this.generationSettings.field_26416);
        }

        public void freeze() {
            this.freezeFeatures();
            if (this.rebuildFeatures) {
                this.rebuildFlowerFeatures();
            }
        }

        private void freezeFeatures() {
            this.generationSettings.field_26416 = ImmutableList.copyOf((Collection)this.generationSettings.field_26416);
            this.generationSettings.field_34465 = Suppliers.memoize(() -> this.generationSettings.field_26416.stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).collect(Collectors.toSet()));
        }

        private void rebuildFlowerFeatures() {
            this.generationSettings.field_26640 = Suppliers.memoize(() -> (List)this.generationSettings.field_26416.stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).flatMap(class_6796::method_39643).filter(configuredFeature -> configuredFeature.comp_332() == class_3031.field_21219).collect(ImmutableList.toImmutableList()));
        }

        @Override
        public boolean removeFeature(class_2893.class_2895 step, class_5321<class_6796> placedFeatureKey) {
            List featureSteps;
            class_6796 placedFeature = (class_6796)BiomeModificationContextImpl.getEntry(this.features, placedFeatureKey).comp_349();
            int stepIndex = step.ordinal();
            if (stepIndex >= (featureSteps = this.generationSettings.field_26416).size()) {
                return false;
            }
            class_6885 featuresInStep = (class_6885)featureSteps.get(stepIndex);
            ArrayList features = new ArrayList(featuresInStep.method_40239().toList());
            if (features.removeIf(feature -> feature.comp_349() == placedFeature)) {
                featureSteps.set(stepIndex, class_6885.method_40242(features));
                this.rebuildFeatures = true;
                return true;
            }
            return false;
        }

        @Override
        public void addFeature(class_2893.class_2895 step, class_5321<class_6796> entry) {
            List featureSteps = this.generationSettings.field_26416;
            int index = step.ordinal();
            while (index >= featureSteps.size()) {
                featureSteps.add(class_6885.method_40242(Collections.emptyList()));
            }
            class_6880.class_6883<class_6796> feature = BiomeModificationContextImpl.getEntry(this.features, entry);
            if (((class_6885)featureSteps.get(index)).method_40241(feature)) {
                return;
            }
            featureSteps.set(index, this.plus((class_6885)((class_6885)featureSteps.get(index)), (class_6880)feature));
            this.rebuildFeatures = true;
        }

        @Override
        public void addCarver(class_5321<class_2922<?>> entry) {
            this.generationSettings.field_26415 = this.plus((class_6885)this.generationSettings.field_26415, (class_6880)BiomeModificationContextImpl.getEntry(this.carvers, entry));
        }

        @Override
        public boolean removeCarver(class_5321<class_2922<?>> configuredCarverKey) {
            class_2922 carver = (class_2922)BiomeModificationContextImpl.getEntry(this.carvers, configuredCarverKey).comp_349();
            ArrayList genCarvers = new ArrayList(this.generationSettings.field_26415.method_40239().toList());
            if (genCarvers.removeIf(entry -> entry.comp_349() == carver)) {
                this.generationSettings.field_26415 = class_6885.method_40242(genCarvers);
                return true;
            }
            return false;
        }

        private <T> class_6885<T> plus(@Nullable class_6885<T> values, class_6880<T> entry) {
            if (values == null) {
                return class_6885.method_40246((class_6880[])new class_6880[]{entry});
            }
            ArrayList list = new ArrayList(values.method_40239().toList());
            list.add(entry);
            return class_6885.method_40242(list);
        }
    }

    private class SpawnSettingsContextImpl
    implements BiomeModificationContext.SpawnSettingsContext {
        private final class_5483 spawnSettings;
        private final EnumMap<class_1311, List<class_6010<class_5483.class_1964>>> fabricSpawners;

        SpawnSettingsContextImpl() {
            this.spawnSettings = BiomeModificationContextImpl.this.biome.method_30966();
            this.fabricSpawners = new EnumMap(class_1311.class);
            this.unfreezeSpawners();
            this.unfreezeSpawnCost();
        }

        private void unfreezeSpawners() {
            this.fabricSpawners.clear();
            for (class_1311 spawnGroup : class_1311.values()) {
                class_6012 entries = (class_6012)this.spawnSettings.field_26405.get(spawnGroup);
                if (entries != null) {
                    this.fabricSpawners.put(spawnGroup, new ArrayList(entries.method_34994()));
                    continue;
                }
                this.fabricSpawners.put(spawnGroup, new ArrayList());
            }
        }

        private void unfreezeSpawnCost() {
            this.spawnSettings.field_26406 = new HashMap(this.spawnSettings.field_26406);
        }

        public void freeze() {
            this.freezeSpawners();
            this.freezeSpawnCosts();
        }

        private void freezeSpawners() {
            HashMap<class_1311, class_6012> spawners = new HashMap<class_1311, class_6012>(this.spawnSettings.field_26405);
            for (Map.Entry<class_1311, List<class_6010<class_5483.class_1964>>> entry : this.fabricSpawners.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    spawners.put(entry.getKey(), class_6012.method_34990());
                    continue;
                }
                spawners.put(entry.getKey(), class_6012.method_34988(entry.getValue()));
            }
            this.spawnSettings.field_26405 = ImmutableMap.copyOf(spawners);
        }

        private void freezeSpawnCosts() {
            this.spawnSettings.field_26406 = ImmutableMap.copyOf((Map)this.spawnSettings.field_26406);
        }

        @Override
        public void setCreatureSpawnProbability(float probability) {
            this.spawnSettings.field_26404 = probability;
        }

        @Override
        public @UnmodifiableView List<class_6010<// Could not load outer class - annotation placement on inner may be incorrect
        class_5483.class_1964>> getSpawnEntries(class_1311 spawnGroup) {
            Objects.requireNonNull(spawnGroup);
            return Collections.unmodifiableList(this.fabricSpawners.get(spawnGroup));
        }

        @Override
        public void addSpawn(class_1311 spawnGroup, class_5483.class_1964 spawnEntry, int weight) {
            Objects.requireNonNull(spawnGroup);
            Objects.requireNonNull(spawnEntry);
            this.fabricSpawners.get(spawnGroup).add((class_6010<class_5483.class_1964>)new class_6010((Object)spawnEntry, weight));
        }

        @Override
        public boolean removeSpawns(BiPredicate<class_1311, class_5483.class_1964> predicate) {
            boolean anyRemoved = false;
            for (class_1311 group : class_1311.values()) {
                if (!this.fabricSpawners.get(group).removeIf(entry -> predicate.test(group, (class_5483.class_1964)entry.comp_2542()))) continue;
                anyRemoved = true;
            }
            return anyRemoved;
        }

        @Override
        public void setSpawnCost(class_1299<?> entityType, double mass, double gravityLimit) {
            Objects.requireNonNull(entityType);
            this.spawnSettings.field_26406.put(entityType, new class_5483.class_5265(gravityLimit, mass));
        }

        @Override
        public void clearSpawnCost(class_1299<?> entityType) {
            this.spawnSettings.field_26406.remove(entityType);
        }
    }
}

