/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.biome;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.impl.biome.TheEndBiomeData;
import net.fabricmc.fabric.mixin.biome.BiomeSourceMixin;
import net.minecraft.class_1959;
import net.minecraft.class_2169;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2169.class})
public class TheEndBiomeSourceMixin
extends BiomeSourceMixin {
    @Shadow
    @Mutable
    @Final
    static MapCodec<class_2169> field_24730;
    @Unique
    private Supplier<TheEndBiomeData.Overrides> overrides;
    @Unique
    private boolean biomeSetModified = false;
    @Unique
    private boolean hasCheckedForModifiedSet = false;

    @Inject(method={"<clinit>()V"}, at={@At(value="TAIL")})
    private static void modifyCodec(CallbackInfo ci) {
        field_24730 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6903.method_46636((class_5321)class_7924.field_41236)).apply((Applicative)instance, instance.stable(class_2169::method_46680)));
    }

    @Inject(method={"method_46680(Lnet/minecraft/class_7871;)Lnet/minecraft/class_2169;"}, at={@At(value="HEAD")})
    private static void rememberLookup(class_7871<class_1959> biomes, CallbackInfoReturnable<?> ci) {
        TheEndBiomeData.biomeRegistry.set(biomes);
    }

    @Inject(method={"method_46680(Lnet/minecraft/class_7871;)Lnet/minecraft/class_2169;"}, at={@At(value="TAIL")})
    private static void clearLookup(class_7871<class_1959> biomes, CallbackInfoReturnable<?> ci) {
        TheEndBiomeData.biomeRegistry.remove();
    }

    @Inject(method={"<init>(Lnet/minecraft/class_6880;Lnet/minecraft/class_6880;Lnet/minecraft/class_6880;Lnet/minecraft/class_6880;Lnet/minecraft/class_6880;)V"}, at={@At(value="RETURN")})
    private void init(class_6880<class_1959> centerBiome, class_6880<class_1959> highlandsBiome, class_6880<class_1959> midlandsBiome, class_6880<class_1959> smallIslandsBiome, class_6880<class_1959> barrensBiome, CallbackInfo ci) {
        class_7871<class_1959> biomes = TheEndBiomeData.biomeRegistry.get();
        if (biomes == null) {
            throw new IllegalStateException("Biome registry not set by Mixin");
        }
        this.overrides = Suppliers.memoize(() -> TheEndBiomeData.createOverrides(biomes));
    }

    @Inject(method={"method_38109(IIILnet/minecraft/class_6544$class_6552;)Lnet/minecraft/class_6880;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getWeightedEndBiome(int biomeX, int biomeY, int biomeZ, class_6544.class_6552 noise, CallbackInfoReturnable<class_6880<class_1959>> cir) {
        cir.setReturnValue(this.overrides.get().pick(biomeX, biomeY, biomeZ, noise, (class_6880<class_1959>)((class_6880)cir.getReturnValue())));
    }

    @Override
    protected Set<class_6880<class_1959>> modifyBiomeSet(Set<class_6880<class_1959>> biomes) {
        if (!this.hasCheckedForModifiedSet) {
            this.hasCheckedForModifiedSet = true;
            boolean bl = this.biomeSetModified = !this.overrides.get().customBiomes.isEmpty();
        }
        if (this.biomeSetModified) {
            LinkedHashSet<class_6880<class_1959>> modifiedBiomes = new LinkedHashSet<class_6880<class_1959>>(biomes);
            modifiedBiomes.addAll(this.overrides.get().customBiomes);
            return Collections.unmodifiableSet(modifiedBiomes);
        }
        return biomes;
    }
}

