/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.biome.v1;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiPredicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.UnmodifiableView;

public interface BiomeModificationContext {
    public WeatherContext getWeather();

    public AttributesContext getAttributes();

    public EffectsContext getEffects();

    public GenerationSettingsContext getGenerationSettings();

    public SpawnSettingsContext getSpawnSettings();

    public static interface SpawnSettingsContext {
        public void setCreatureSpawnProbability(float var1);

        public @UnmodifiableView List<Weighted<// Could not load outer class - annotation placement on inner may be incorrect
        MobSpawnSettings.SpawnerData>> getSpawnEntries(MobCategory var1);

        public void addSpawn(MobCategory var1, MobSpawnSettings.SpawnerData var2, int var3);

        public boolean removeSpawns(BiPredicate<MobCategory, MobSpawnSettings.SpawnerData> var1);

        default public boolean removeSpawnsOfEntityType(EntityType<?> entityType) {
            return this.removeSpawns((spawnGroup, spawnEntry) -> spawnEntry.type() == entityType);
        }

        default public void clearSpawns(MobCategory group) {
            this.removeSpawns((spawnGroup, spawnEntry) -> spawnGroup == group);
        }

        default public void clearSpawns() {
            this.removeSpawns((spawnGroup, spawnEntry) -> true);
        }

        public void setSpawnCost(EntityType<?> var1, double var2, double var4);

        public void clearSpawnCost(EntityType<?> var1);
    }

    public static interface GenerationSettingsContext {
        public boolean removeFeature(GenerationStep.Decoration var1, ResourceKey<PlacedFeature> var2);

        default public boolean removeFeature(ResourceKey<PlacedFeature> placedFeatureKey) {
            boolean anyFound = false;
            for (GenerationStep.Decoration step : GenerationStep.Decoration.values()) {
                if (!this.removeFeature(step, placedFeatureKey)) continue;
                anyFound = true;
            }
            return anyFound;
        }

        public void addFeature(GenerationStep.Decoration var1, ResourceKey<PlacedFeature> var2);

        public void addCarver(ResourceKey<ConfiguredWorldCarver<?>> var1);

        public boolean removeCarver(ResourceKey<ConfiguredWorldCarver<?>> var1);
    }

    public static interface EffectsContext {
        @Deprecated
        public void setFogColor(int var1);

        public void setWaterColor(int var1);

        @Deprecated
        public void setWaterFogColor(int var1);

        @Deprecated
        public void setSkyColor(int var1);

        public void setFoliageColor(Optional<Integer> var1);

        default public void setFoliageColor(int color) {
            this.setFoliageColor(Optional.of(color));
        }

        default public void setFoliageColor(OptionalInt color) {
            color.ifPresentOrElse(this::setFoliageColor, this::clearFoliageColor);
        }

        default public void clearFoliageColor() {
            this.setFoliageColor(Optional.empty());
        }

        public void setDryFoliageColor(Optional<Integer> var1);

        default public void setDryFoliageColor(int color) {
            this.setDryFoliageColor(Optional.of(color));
        }

        default public void setDryFoliageColor(OptionalInt color) {
            color.ifPresentOrElse(this::setDryFoliageColor, this::clearDryFoliageColor);
        }

        default public void clearDryFoliageColor() {
            this.setDryFoliageColor(Optional.empty());
        }

        public void setGrassColor(Optional<Integer> var1);

        default public void setGrassColor(int color) {
            this.setGrassColor(Optional.of(color));
        }

        default public void setGrassColor(OptionalInt color) {
            color.ifPresentOrElse(this::setGrassColor, this::clearGrassColor);
        }

        default public void clearGrassColor() {
            this.setGrassColor(Optional.empty());
        }

        public void setGrassColorModifier(BiomeSpecialEffects.GrassColorModifier var1);

        @Deprecated
        public void setMusicVolume(float var1);
    }

    public static interface AttributesContext {
        public void addAll(EnvironmentAttributeMap var1);

        default public void addAll(EnvironmentAttributeMap.Builder map) {
            this.addAll(map.build());
        }

        public <T> void set(EnvironmentAttribute<T> var1, T var2);

        public <T, M> void setModifier(EnvironmentAttribute<T> var1, AttributeModifier<T, M> var2, M var3);
    }

    public static interface WeatherContext {
        public void setPrecipitation(boolean var1);

        public void setTemperature(float var1);

        public void setTemperatureModifier(Biome.TemperatureModifier var1);

        public void setDownfall(float var1);
    }
}

