/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biomes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.biomes.v1.OverworldClimate;
import net.fabricmc.fabric.impl.biomes.BiomeVariant;
import net.minecraft.class_1959;
import net.minecraft.class_3630;

final class VariantTransformer {
    private final SubTransformer defaultTransformer = new SubTransformer();
    private final Map<OverworldClimate, SubTransformer> transformers = new HashMap<OverworldClimate, SubTransformer>();

    VariantTransformer() {
    }

    void addBiome(class_1959 variant, double chance, OverworldClimate[] climates) {
        if (climates == null || climates.length == 0) {
            this.defaultTransformer.addBiome(variant, chance);
            climates = OverworldClimate.values();
        }
        for (OverworldClimate climate : climates) {
            this.transformers.computeIfAbsent(climate, c -> new SubTransformer()).addBiome(variant, chance);
        }
    }

    class_1959 transformBiome(class_1959 replaced, class_3630 random, OverworldClimate climate) {
        if (climate == null) {
            return this.defaultTransformer.transformBiome(replaced, random);
        }
        SubTransformer transformer = this.transformers.get((Object)climate);
        if (transformer != null) {
            return transformer.transformBiome(replaced, random);
        }
        return replaced;
    }

    static final class SubTransformer {
        private final List<BiomeVariant> variants = new ArrayList<BiomeVariant>();

        SubTransformer() {
        }

        private void addBiome(class_1959 variant, double chance) {
            this.variants.add(new BiomeVariant(variant, chance));
        }

        private class_1959 transformBiome(class_1959 replaced, class_3630 random) {
            for (BiomeVariant variant : this.variants) {
                if (!((double)random.method_15834(Integer.MAX_VALUE) < variant.getChance() * 2.147483647E9)) continue;
                return variant.getVariant();
            }
            return replaced;
        }
    }
}

