/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biomes;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.impl.biomes.ContinentalBiomeEntry;
import net.minecraft.class_1959;
import net.minecraft.class_3630;

public final class WeightedBiomePicker {
    private double currentTotal = 0.0;
    private List<ContinentalBiomeEntry> entries = new ArrayList<ContinentalBiomeEntry>();

    WeightedBiomePicker() {
    }

    void addBiome(class_1959 biome, double weight) {
        this.currentTotal += weight;
        this.entries.add(new ContinentalBiomeEntry(biome, weight, this.currentTotal));
    }

    double getCurrentWeightTotal() {
        return this.currentTotal;
    }

    public class_1959 pickRandom(class_3630 random) {
        double target = (double)random.method_15834(Integer.MAX_VALUE) * this.getCurrentWeightTotal() / 2.147483647E9;
        return this.search(target).getBiome();
    }

    ContinentalBiomeEntry search(double target) {
        Preconditions.checkArgument((target <= this.currentTotal ? 1 : 0) != 0, (Object)"The provided target value for biome selection must be less than or equal to the weight total");
        Preconditions.checkArgument((target >= 0.0 ? 1 : 0) != 0, (Object)"The provided target value for biome selection cannot be negative");
        int low = 0;
        int high = this.entries.size() - 1;
        while (low < high) {
            int mid = high + low >>> 1;
            if (target < this.entries.get(mid).getUpperWeightBound()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return this.entries.get(low);
    }
}

