/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biomes;

import net.fabricmc.fabric.impl.biomes.InternalBiomeData;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/**
 * Adds spawn biomes to the base {@link BiomeSource} class.
 */
@Mixin(class_1966.class)
public class MixinBiomeSource {

	@Shadow
	@Final
	private static List<class_1959> SPAWN_BIOMES;

	@Inject(at = @At("RETURN"), cancellable = true, method = "getSpawnBiomes")
	private void getSpawnBiomes(CallbackInfoReturnable<List<class_1959>> info) {
		Set<class_1959> biomes = new LinkedHashSet<>(info.getReturnValue());
		if (biomes.addAll(InternalBiomeData.getSpawnBiomes())) {
			info.setReturnValue(new ArrayList<>(biomes));
		}
	}

}
