/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.biomes.v1.OverworldClimate;
import net.fabricmc.fabric.impl.biome.VariantTransformer;
import net.fabricmc.fabric.impl.biome.WeightedBiomePicker;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2088;
import net.minecraft.class_2378;
import net.minecraft.class_3645;

public final class InternalBiomeData {
    private static final EnumMap<OverworldClimate, WeightedBiomePicker> OVERWORLD_MODDED_CONTINENTAL_BIOME_PICKERS = new EnumMap(OverworldClimate.class);
    private static final Map<class_1959, WeightedBiomePicker> OVERWORLD_HILLS_MAP = new HashMap<class_1959, WeightedBiomePicker>();
    private static final Map<class_1959, WeightedBiomePicker> OVERWORLD_SHORE_MAP = new HashMap<class_1959, WeightedBiomePicker>();
    private static final Map<class_1959, WeightedBiomePicker> OVERWORLD_EDGE_MAP = new HashMap<class_1959, WeightedBiomePicker>();
    private static final Map<class_1959, VariantTransformer> OVERWORLD_VARIANT_TRANSFORMERS = new HashMap<class_1959, VariantTransformer>();
    private static final Map<class_1959, class_1959> OVERWORLD_RIVER_MAP = new HashMap<class_1959, class_1959>();
    private static final Set<class_1959> NETHER_BIOMES = new HashSet<class_1959>();
    private static final Set<class_1959> SPAWN_BIOMES = new HashSet<class_1959>();
    private static Method injectBiomeMethod = null;

    private InternalBiomeData() {
    }

    public static void addOverworldContinentalBiome(OverworldClimate climate, class_1959 biome, double weight) {
        Preconditions.checkArgument((climate != null ? 1 : 0) != 0, (Object)"Climate is null");
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        OVERWORLD_MODDED_CONTINENTAL_BIOME_PICKERS.computeIfAbsent(climate, k -> new WeightedBiomePicker()).addBiome(biome, weight);
        InternalBiomeData.injectOverworldBiome(biome);
    }

    public static void addOverworldHillsBiome(class_1959 primary, class_1959 hills, double weight) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        Preconditions.checkArgument((hills != null ? 1 : 0) != 0, (Object)"Hills biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        OVERWORLD_HILLS_MAP.computeIfAbsent(primary, biome -> DefaultHillsData.injectDefaultHills(primary, new WeightedBiomePicker())).addBiome(hills, weight);
        InternalBiomeData.injectOverworldBiome(hills);
    }

    public static void addOverworldShoreBiome(class_1959 primary, class_1959 shore, double weight) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        Preconditions.checkArgument((shore != null ? 1 : 0) != 0, (Object)"Shore biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        OVERWORLD_SHORE_MAP.computeIfAbsent(primary, biome -> new WeightedBiomePicker()).addBiome(shore, weight);
        InternalBiomeData.injectOverworldBiome(shore);
    }

    public static void addOverworldEdgeBiome(class_1959 primary, class_1959 edge, double weight) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        Preconditions.checkArgument((edge != null ? 1 : 0) != 0, (Object)"Edge biome is null");
        Preconditions.checkArgument((!Double.isNaN(weight) ? 1 : 0) != 0, (Object)"Weight is NaN");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (%s)", (Object)weight);
        OVERWORLD_EDGE_MAP.computeIfAbsent(primary, biome -> new WeightedBiomePicker()).addBiome(edge, weight);
        InternalBiomeData.injectOverworldBiome(edge);
    }

    public static void addOverworldBiomeReplacement(class_1959 replaced, class_1959 variant, double chance, OverworldClimate[] climates) {
        Preconditions.checkArgument((replaced != null ? 1 : 0) != 0, (Object)"Replaced biome is null");
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"Variant biome is null");
        Preconditions.checkArgument((chance > 0.0 && chance <= 1.0 ? 1 : 0) != 0, (Object)"Chance is not greater than 0 or less than or equal to 1");
        OVERWORLD_VARIANT_TRANSFORMERS.computeIfAbsent(replaced, biome -> new VariantTransformer()).addBiome(variant, chance, climates);
        InternalBiomeData.injectOverworldBiome(variant);
    }

    public static void setOverworldRiverBiome(class_1959 primary, class_1959 river) {
        Preconditions.checkArgument((primary != null ? 1 : 0) != 0, (Object)"Primary biome is null");
        OVERWORLD_RIVER_MAP.put(primary, river);
        if (river != null) {
            InternalBiomeData.injectOverworldBiome(river);
        }
    }

    public static void addSpawnBiome(class_1959 biome) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome is null");
        SPAWN_BIOMES.add(biome);
    }

    private static void injectOverworldBiome(class_1959 biome) {
        try {
            if (injectBiomeMethod == null) {
                injectBiomeMethod = class_2088.class.getDeclaredMethod("fabric_injectBiome", class_1959.class);
                injectBiomeMethod.setAccessible(true);
            }
            injectBiomeMethod.invoke(null, biome);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addNetherBiome(class_1959 biome) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome is null");
        NETHER_BIOMES.add(biome);
    }

    public static Set<class_1959> getSpawnBiomes() {
        return SPAWN_BIOMES;
    }

    public static Map<class_1959, WeightedBiomePicker> getOverworldHills() {
        return OVERWORLD_HILLS_MAP;
    }

    public static Map<class_1959, WeightedBiomePicker> getOverworldShores() {
        return OVERWORLD_SHORE_MAP;
    }

    public static Map<class_1959, WeightedBiomePicker> getOverworldEdges() {
        return OVERWORLD_EDGE_MAP;
    }

    public static Map<class_1959, class_1959> getOverworldRivers() {
        return OVERWORLD_RIVER_MAP;
    }

    public static EnumMap<OverworldClimate, WeightedBiomePicker> getOverworldModdedContinentalBiomePickers() {
        return OVERWORLD_MODDED_CONTINENTAL_BIOME_PICKERS;
    }

    public static Map<class_1959, VariantTransformer> getOverworldVariantTransformers() {
        return OVERWORLD_VARIANT_TRANSFORMERS;
    }

    public static Set<class_1959> getNetherBiomes() {
        return Collections.unmodifiableSet(NETHER_BIOMES);
    }

    private static class DefaultHillsData {
        private static final ImmutableMap<class_1959, class_1959> DEFAULT_HILLS;

        private DefaultHillsData() {
        }

        static WeightedBiomePicker injectDefaultHills(class_1959 base, WeightedBiomePicker picker) {
            class_1959 defaultHill = (class_1959)DEFAULT_HILLS.get((Object)base);
            if (defaultHill != null) {
                picker.addBiome(defaultHill, 1.0);
            } else if (class_3645.method_15844((int)class_2378.field_11153.method_10249((Object)base), (int)class_2378.field_11153.method_10249((Object)class_1972.field_9410))) {
                picker.addBiome(class_1972.field_9415, 1.0);
            } else if (base == class_1972.field_9446 || base == class_1972.field_9439 || base == class_1972.field_9470) {
                picker.addBiome(class_1972.field_9451, 1.0);
                picker.addBiome(class_1972.field_9409, 1.0);
            } else if (base == class_1972.field_9418) {
                picker.addBiome(class_1972.field_9451, 0.25);
                picker.addBiome(class_1972.field_9409, 0.25);
            } else if (base == class_1972.field_9451) {
                picker.addBiome(class_1972.field_9459, 1.0);
                picker.addBiome(class_1972.field_9409, 2.0);
            }
            return picker;
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)class_1972.field_9424, (Object)class_1972.field_9466);
            builder.put((Object)class_1972.field_9409, (Object)class_1972.field_9459);
            builder.put((Object)class_1972.field_9412, (Object)class_1972.field_9421);
            builder.put((Object)class_1972.field_9475, (Object)class_1972.field_9451);
            builder.put((Object)class_1972.field_9420, (Object)class_1972.field_9428);
            builder.put((Object)class_1972.field_9477, (Object)class_1972.field_9429);
            builder.put((Object)class_1972.field_9454, (Object)class_1972.field_9425);
            builder.put((Object)class_1972.field_9452, (Object)class_1972.field_9444);
            builder.put((Object)class_1972.field_9417, (Object)class_1972.field_9432);
            builder.put((Object)class_1972.field_9440, (Object)class_1972.field_9468);
            builder.put((Object)class_1972.field_9423, (Object)class_1972.field_9446);
            builder.put((Object)class_1972.field_9441, (Object)class_1972.field_9439);
            builder.put((Object)class_1972.field_9467, (Object)class_1972.field_9470);
            builder.put((Object)class_1972.field_9435, (Object)class_1972.field_9418);
            builder.put((Object)class_1972.field_9472, (Object)class_1972.field_9460);
            builder.put((Object)class_1972.field_9449, (Object)class_1972.field_9430);
            DEFAULT_HILLS = builder.build();
        }
    }
}

