/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome;

import java.util.ArrayList;
import java.util.List;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import net.minecraft.class_1959;
import net.minecraft.class_5285;

import net.fabricmc.fabric.impl.biome.InternalBiomeData;

@Mixin(class_5285.class)
public class MixinTheNetherDimension {
	@ModifyArg(method = "method_28026", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/biome/source/MultiNoiseBiomeSource;method_27986(JLjava/util/List;)Lnet/minecraft/world/biome/source/MultiNoiseBiomeSource;"))
	private static List<class_1959> modifyNetherBiomes(List<class_1959> list) {
		// the provided set is immutable, so we construct our own
		List<class_1959> newList = new ArrayList<>(list);
		newList.addAll(InternalBiomeData.getNetherBiomes());
		return newList;
	}
}
