/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.biome.InternalBiomeUtils;
import net.minecraft.class_3176;
import net.minecraft.class_3807;

@Mixin(class_3176.class)
public class MixinMinecraftDedicatedServer {
	@Shadow
	@Final
	private class_3807 propertiesLoader;

	@Inject(method = "setupServer", at = @At("HEAD"))
	public void setupServer(CallbackInfoReturnable<Boolean> cir) {
		InternalBiomeUtils.recreateChunkGenerators(propertiesLoader.method_16717().field_24623);
	}
}
