/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.biomes.v1.OverworldBiomes;
import net.fabricmc.fabric.impl.biome.InternalBiomeData;
import net.fabricmc.fabric.impl.biome.WeightedBiomePicker;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_3625;
import net.minecraft.class_3630;
import net.minecraft.class_3645;
import net.minecraft.class_3648;
import net.minecraft.class_5458;

/**
 * Injects hills biomes specified from {@link OverworldBiomes#addHillsBiome(Biome, Biome, double)}into the default hills layer.
 */
@Mixin(class_3648.class)
public class MixinAddHillsLayer {
	@Inject(at = @At("HEAD"), method = "sample", cancellable = true)
	private void sample(class_3630 rand, class_3625 biomeSampler, class_3625 noiseSampler, int chunkX, int chunkZ, CallbackInfoReturnable<Integer> info) {
		if (InternalBiomeData.getOverworldHills().isEmpty()) {
			// No use doing anything if there are no hills registered. Fall through to vanilla logic.
			return;
		}

		final int biomeId = biomeSampler.method_15825(chunkX, chunkZ);
		int noiseSample = noiseSampler.method_15825(chunkX, chunkZ);
		int processedNoiseSample = (noiseSample - 2) % 29;
		final class_1959 biome = class_5458.field_25933.method_10200(biomeId);

		WeightedBiomePicker hillPicker = InternalBiomeData.getOverworldHills().get(biome);

		if (hillPicker == null) {
			// No hills for this biome, fall through to vanilla logic.

			return;
		}

		if (rand.method_15834(3) == 0 || processedNoiseSample == 0) {
			int biomeReturn = class_5458.field_25933.method_10206(hillPicker.pickRandom(rand));
			class_1959 parent;

			if (processedNoiseSample == 0 && biomeReturn != biomeId) {
				parent = class_1972.method_30360(class_5458.field_25933.method_10200(biomeReturn));
				biomeReturn = parent == null ? biomeId : class_5458.field_25933.method_10206(parent);
			}

			if (biomeReturn != biomeId) {
				int similarity = 0;

				if (class_3645.method_15844(biomeSampler.method_15825(chunkX, chunkZ - 1), biomeId)) {
					++similarity;
				}

				if (class_3645.method_15844(biomeSampler.method_15825(chunkX + 1, chunkZ), biomeId)) {
					++similarity;
				}

				if (class_3645.method_15844(biomeSampler.method_15825(chunkX - 1, chunkZ), biomeId)) {
					++similarity;
				}

				if (class_3645.method_15844(biomeSampler.method_15825(chunkX, chunkZ + 1), biomeId)) {
					++similarity;
				}

				if (similarity >= 3) {
					info.setReturnValue(biomeReturn);
					return;
				}
			}
		}

		// Cancel vanilla logic.
		info.setReturnValue(biomeId);
	}
}
